/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.om;

import net2.sf.saxon.Configuration;
import net2.sf.saxon.event.Receiver;
import net2.sf.saxon.om.AxisIterator;
import net2.sf.saxon.om.DocumentInfo;
import net2.sf.saxon.om.EmptyIterator;
import net2.sf.saxon.om.FastStringBuffer;
import net2.sf.saxon.om.FingerprintedNode;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.om.Navigator;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.PrependIterator;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.SingleNodeIterator;
import net2.sf.saxon.om.SingletonIterator;
import net2.sf.saxon.pattern.AnyNodeTest;
import net2.sf.saxon.pattern.NodeKindTest;
import net2.sf.saxon.pattern.NodeTest;
import net2.sf.saxon.sort.IntHashSet;
import net2.sf.saxon.sort.IntIterator;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.StringValue;
import net2.sf.saxon.value.Value;

public class NamespaceIterator
implements AxisIterator {
    private NodeInfo element;
    private NodeTest test;
    private int index;
    private int position;
    private NamespaceNodeImpl next;
    private NamespaceNodeImpl current;
    private IntIterator nsIterator;
    private static int[] XML_NAMESPACE_CODE_ARRAY = new int[]{65537};

    public static AxisIterator makeIterator(NodeInfo element, NodeTest test) {
        boolean first = true;
        if (test instanceof AnyNodeTest || test == NodeKindTest.NAMESPACE) {
            test = null;
        }
        NamespaceIterator result = null;
        IntHashSet declared = null;
        IntHashSet undeclared = null;
        int[] buffer = new int[8];
        NodeInfo node = element;
        while (node != null && node.getNodeKind() == 1) {
            int[] nslist = node.getDeclaredNamespaces(buffer);
            if (nslist != null) {
                int i = 0;
                while (i < nslist.length) {
                    if (nslist[i] == -1) break;
                    if (first) {
                        NamespaceIterator nsi = new NamespaceIterator();
                        nsi.element = element;
                        nsi.test = test;
                        nsi.index = -1;
                        undeclared = new IntHashSet(8);
                        declared = new IntHashSet(8);
                        declared.add(65537);
                        first = false;
                        result = nsi;
                    }
                    short uriCode = (short)(nslist[i] & 0xFFFF);
                    short prefixCode = (short)(nslist[i] >> 16);
                    if (uriCode == 0) {
                        undeclared.add(prefixCode);
                    } else if (!undeclared.contains(prefixCode)) {
                        declared.add(nslist[i]);
                        undeclared.add(prefixCode);
                    }
                    ++i;
                }
            }
            node = node.getParent();
        }
        if (result == null) {
            NamespaceNodeImpl ns = new NamespaceNodeImpl(element, 65537, 0);
            if (test == null) {
                return SingleNodeIterator.makeIterator(ns);
            }
            return Navigator.filteredSingleton(ns, test);
        }
        ((NamespaceIterator)result).nsIterator = declared.iterator();
        return result;
    }

    private NamespaceIterator() {
    }

    public void advance() {
        while (this.nsIterator.hasNext()) {
            int nscode = this.nsIterator.next();
            this.next = new NamespaceNodeImpl(this.element, nscode, ++this.index);
            if (this.test != null && !this.test.matches(this.next)) continue;
            return;
        }
        this.next = null;
    }

    @Override
    public boolean moveNext() {
        return this.next() != null;
    }

    @Override
    public Item next() {
        if (this.index == -1) {
            this.advance();
            this.index = 0;
        }
        this.current = this.next;
        if (this.current == null) {
            this.position = -1;
            return null;
        }
        this.advance();
        ++this.position;
        return this.current;
    }

    @Override
    public Item current() {
        return this.current;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public void close() {
    }

    @Override
    public AxisIterator iterateAxis(byte axis, NodeTest test) {
        return this.current.iterateAxis(axis, test);
    }

    @Override
    public Value atomize() throws XPathException {
        return this.current.atomize();
    }

    @Override
    public CharSequence getStringValue() {
        return this.current.getStringValueCS();
    }

    @Override
    public SequenceIterator getAnother() {
        return NamespaceIterator.makeIterator(this.element, this.test);
    }

    @Override
    public int getProperties() {
        return 0;
    }

    public static int[] getInScopeNamespaceCodes(NodeInfo element) {
        int i;
        boolean first = true;
        IntHashSet declared = null;
        IntHashSet undeclared = null;
        int[] buffer = new int[8];
        NodeInfo node = element;
        while (node != null && node.getNodeKind() == 1) {
            int[] nslist = node.getDeclaredNamespaces(buffer);
            if (nslist != null) {
                i = 0;
                while (i < nslist.length) {
                    if (nslist[i] == -1) break;
                    if (first) {
                        undeclared = new IntHashSet(8);
                        declared = new IntHashSet(8);
                        declared.add(65537);
                        first = false;
                    }
                    short uriCode = (short)(nslist[i] & 0xFFFF);
                    short prefixCode = (short)(nslist[i] >> 16);
                    if (uriCode == 0) {
                        undeclared.add(prefixCode);
                    } else if (!undeclared.contains(prefixCode)) {
                        declared.add(nslist[i]);
                        undeclared.add(prefixCode);
                    }
                    ++i;
                }
            }
            node = node.getParent();
        }
        if (first) {
            return XML_NAMESPACE_CODE_ARRAY;
        }
        try {
            int[] codes = new int[declared.size()];
            i = 0;
            IntIterator ii = declared.iterator();
            while (ii.hasNext()) {
                codes[i++] = ii.next();
            }
            return codes;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("*** Internal error in NamespaceIterator ***");
            declared.diagnosticDump();
            throw e;
        }
    }

    public static class NamespaceNodeImpl
    implements NodeInfo,
    FingerprintedNode {
        NodeInfo element;
        int nscode;
        int position;
        String prefix;
        int namecode;

        public NamespaceNodeImpl(NodeInfo element, int nscode, int position) {
            this.element = element;
            this.nscode = nscode;
            this.position = position;
            NamePool pool = element.getNamePool();
            this.prefix = pool.getPrefixFromNamespaceCode(nscode);
            this.namecode = -1;
        }

        @Override
        public int getNodeKind() {
            return 13;
        }

        @Override
        public boolean isSameNodeInfo(NodeInfo other) {
            return other instanceof NamespaceNodeImpl && this.element.isSameNodeInfo(((NamespaceNodeImpl)other).element) && this.nscode == ((NamespaceNodeImpl)other).nscode;
        }

        @Override
        public boolean equals(Object other) {
            return other instanceof NodeInfo && this.isSameNodeInfo((NodeInfo)other);
        }

        @Override
        public int hashCode() {
            return this.element.hashCode() ^ this.position << 13;
        }

        @Override
        public String getSystemId() {
            return this.element.getSystemId();
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public int getLineNumber() {
            return this.element.getLineNumber();
        }

        @Override
        public int getColumnNumber() {
            return this.element.getColumnNumber();
        }

        @Override
        public int compareOrder(NodeInfo other) {
            if (other instanceof NamespaceNodeImpl && this.element.isSameNodeInfo(((NamespaceNodeImpl)other).element)) {
                int c = this.position - ((NamespaceNodeImpl)other).position;
                if (c == 0) {
                    return 0;
                }
                if (c < 0) {
                    return -1;
                }
                return 1;
            }
            if (this.element.isSameNodeInfo(other)) {
                return 1;
            }
            return this.element.compareOrder(other);
        }

        @Override
        public String getStringValue() {
            return this.element.getNamePool().getURIFromURICode((short)(this.nscode & 0xFFFF));
        }

        @Override
        public CharSequence getStringValueCS() {
            return this.getStringValue();
        }

        @Override
        public int getNameCode() {
            if (this.namecode == -1) {
                if (this.prefix.length() == 0) {
                    return -1;
                }
                this.namecode = this.element.getNamePool().allocate("", "", this.prefix);
            }
            return this.namecode;
        }

        @Override
        public int getFingerprint() {
            if (this.prefix.length() == 0) {
                return -1;
            }
            return this.getNameCode() & 0xFFFFF;
        }

        @Override
        public String getLocalPart() {
            return this.prefix;
        }

        @Override
        public String getURI() {
            return "";
        }

        @Override
        public String getDisplayName() {
            return this.getLocalPart();
        }

        @Override
        public String getPrefix() {
            return "";
        }

        @Override
        public Configuration getConfiguration() {
            return this.element.getConfiguration();
        }

        @Override
        public NamePool getNamePool() {
            return this.element.getNamePool();
        }

        @Override
        public int getTypeAnnotation() {
            return 513;
        }

        @Override
        public NodeInfo getParent() {
            return this.element;
        }

        @Override
        public AxisIterator iterateAxis(byte axisNumber) {
            return this.iterateAxis(axisNumber, AnyNodeTest.getInstance());
        }

        @Override
        public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
            switch (axisNumber) {
                case 0: {
                    return this.element.iterateAxis((byte)1, nodeTest);
                }
                case 1: {
                    if (nodeTest.matches(this)) {
                        return new PrependIterator(this, this.element.iterateAxis((byte)1, nodeTest));
                    }
                    return this.element.iterateAxis((byte)1, nodeTest);
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 11: {
                    return EmptyIterator.getInstance();
                }
                case 6: {
                    return new Navigator.AxisFilter(new Navigator.FollowingEnumeration(this), nodeTest);
                }
                case 9: {
                    return Navigator.filteredSingleton(this.element, nodeTest);
                }
                case 10: {
                    return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, false), nodeTest);
                }
                case 12: {
                    return Navigator.filteredSingleton(this, nodeTest);
                }
                case 13: {
                    return new Navigator.AxisFilter(new Navigator.PrecedingEnumeration(this, true), nodeTest);
                }
            }
            throw new IllegalArgumentException("Unknown axis number " + axisNumber);
        }

        @Override
        public String getAttributeValue(int fingerprint) {
            return null;
        }

        @Override
        public NodeInfo getRoot() {
            return this.element.getRoot();
        }

        @Override
        public DocumentInfo getDocumentRoot() {
            return this.element.getDocumentRoot();
        }

        @Override
        public boolean hasChildNodes() {
            return false;
        }

        @Override
        public void generateId(FastStringBuffer buffer) {
            this.element.generateId(buffer);
            buffer.append("n");
            buffer.append(Integer.toString(this.position));
        }

        @Override
        public long getDocumentNumber() {
            return this.element.getDocumentNumber();
        }

        @Override
        public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
            out.namespace(this.nscode, 32);
        }

        @Override
        public int[] getDeclaredNamespaces(int[] buffer) {
            return null;
        }

        @Override
        public void setSystemId(String systemId) {
        }

        @Override
        public SequenceIterator getTypedValue() throws XPathException {
            return SingletonIterator.makeIterator(new StringValue(this.getStringValueCS()));
        }

        @Override
        public Value atomize() throws XPathException {
            return new StringValue(this.getStringValueCS());
        }

        @Override
        public boolean isId() {
            return false;
        }

        @Override
        public boolean isIdref() {
            return false;
        }

        @Override
        public boolean isNilled() {
            return false;
        }
    }
}

