/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.om;

import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.om.NamespaceDeclarations;

public class NamespaceDeclarationsImpl
implements NamespaceDeclarations {
    private NamePool namePool;
    private int[] namespaceCodes;
    private int used;
    private static final int[] emptyArray = new int[0];

    public NamespaceDeclarationsImpl() {
    }

    public NamespaceDeclarationsImpl(NamePool pool, int[] codes) {
        this.namePool = pool;
        this.setNamespaceCodes(codes);
    }

    public void setNamePool(NamePool pool) {
        this.namePool = pool;
    }

    public void setNamespaceCodes(int[] codes) {
        if (codes == null) {
            codes = emptyArray;
        }
        this.namespaceCodes = codes;
        this.used = codes.length;
        int i = 0;
        while (i < codes.length) {
            if (codes[i] == -1) {
                this.used = i;
                break;
            }
            ++i;
        }
    }

    @Override
    public int[] getNamespaceCodes(int[] buffer) {
        return this.namespaceCodes;
    }

    @Override
    public int getNumberOfNamespaces() {
        return this.used;
    }

    @Override
    public String getPrefix(int index) {
        return this.namePool.getPrefixFromNamespaceCode(this.namespaceCodes[index]);
    }

    @Override
    public String getURI(int index) {
        return this.namePool.getURIFromNamespaceCode(this.namespaceCodes[index]);
    }

    @Override
    public int getNamespaceCode(int index) {
        return this.namespaceCodes[index];
    }
}

