/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.om;

import java.util.List;
import net2.sf.saxon.expr.LastPositionFinder;
import net2.sf.saxon.om.GroundedIterator;
import net2.sf.saxon.om.GroundedValue;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.LookaheadIterator;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.UnfailingIterator;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.EmptySequence;
import net2.sf.saxon.value.SequenceExtent;
import net2.sf.saxon.value.SingletonItem;

public class ListIterator
implements UnfailingIterator,
LastPositionFinder,
LookaheadIterator,
GroundedIterator {
    int index = 0;
    int length;
    Item current = null;
    List list = null;

    public ListIterator(List list) {
        this.list = list;
        this.length = list.size();
    }

    public ListIterator(List list, int length) {
        this.list = list;
        this.length = length;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.length;
    }

    @Override
    public Item next() {
        if (this.index >= this.length) {
            this.current = null;
            this.index = -1;
            this.length = -1;
            return null;
        }
        this.current = (Item)this.list.get(this.index++);
        return this.current;
    }

    @Override
    public Item current() {
        return this.current;
    }

    @Override
    public int position() {
        return this.index;
    }

    @Override
    public void close() {
    }

    @Override
    public int getLastPosition() {
        return this.length;
    }

    @Override
    public SequenceIterator getAnother() {
        return new ListIterator(this.list);
    }

    @Override
    public int getProperties() {
        return 7;
    }

    @Override
    public GroundedValue materialize() {
        if (this.length == 0) {
            return EmptySequence.getInstance();
        }
        if (this.length == 1) {
            Item item = (Item)this.list.get(0);
            if (item instanceof NodeInfo) {
                return new SingletonItem((NodeInfo)item);
            }
            return (AtomicValue)item;
        }
        return new SequenceExtent(this.list);
    }
}

