/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.om;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net2.sf.saxon.om.DocumentInfo;
import net2.sf.saxon.om.NodeInfo;

public final class DocumentPool
implements Serializable {
    private Map<String, DocumentInfo> documentNameMap = new HashMap<String, DocumentInfo>(10);
    private Set<String> unavailableDocuments = new HashSet<String>(10);

    public void add(DocumentInfo doc, String uri) {
        if (uri != null) {
            this.documentNameMap.put(uri, doc);
        }
    }

    public DocumentInfo find(String uri) {
        return this.documentNameMap.get(uri);
    }

    public String getDocumentURI(NodeInfo doc) {
        for (String uri : this.documentNameMap.keySet()) {
            if (!this.find(uri).isSameNodeInfo(doc)) continue;
            return uri;
        }
        return null;
    }

    public DocumentInfo discard(DocumentInfo doc) {
        for (String name : this.documentNameMap.keySet()) {
            DocumentInfo entry = this.documentNameMap.get(name);
            if (entry != doc) continue;
            this.documentNameMap.remove(name);
            return doc;
        }
        return doc;
    }

    public void markUnavailable(String uri) {
        this.unavailableDocuments.add(uri);
    }

    public boolean isMarkedUnavailable(String uri) {
        return this.unavailableDocuments.contains(uri);
    }
}

