/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.om;

import net2.sf.saxon.trans.XPathException;

public final class Axis {
    public static final byte ANCESTOR = 0;
    public static final byte ANCESTOR_OR_SELF = 1;
    public static final byte ATTRIBUTE = 2;
    public static final byte CHILD = 3;
    public static final byte DESCENDANT = 4;
    public static final byte DESCENDANT_OR_SELF = 5;
    public static final byte FOLLOWING = 6;
    public static final byte FOLLOWING_SIBLING = 7;
    public static final byte NAMESPACE = 8;
    public static final byte PARENT = 9;
    public static final byte PRECEDING = 10;
    public static final byte PRECEDING_SIBLING = 11;
    public static final byte SELF = 12;
    public static final byte PRECEDING_OR_ANCESTOR = 13;
    public static final short[] principalNodeType = new short[]{1, 1, 2, 1, 1, 1, 1, 1, 13, 1, 1, 1, 1, 1};
    public static final boolean[] isForwards;
    public static final boolean[] isPeerAxis;
    public static final boolean[] isSubtreeAxis;
    public static final String[] axisName;
    public static final String[] axisJavaName;
    private static final int DOC = 512;
    private static final int ELE = 2;
    private static final int ATT = 4;
    private static final int TEX = 8;
    private static final int PIN = 128;
    private static final int COM = 256;
    private static final int NAM = 8192;
    private static int[] voidAxisTable;
    private static int[] nodeKindTable;

    static {
        boolean[] blArray = new boolean[14];
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        blArray[7] = true;
        blArray[8] = true;
        blArray[9] = true;
        blArray[12] = true;
        isForwards = blArray;
        boolean[] blArray2 = new boolean[14];
        blArray2[2] = true;
        blArray2[3] = true;
        blArray2[7] = true;
        blArray2[8] = true;
        blArray2[9] = true;
        blArray2[11] = true;
        blArray2[12] = true;
        isPeerAxis = blArray2;
        boolean[] blArray3 = new boolean[14];
        blArray3[2] = true;
        blArray3[3] = true;
        blArray3[4] = true;
        blArray3[5] = true;
        blArray3[8] = true;
        blArray3[12] = true;
        isSubtreeAxis = blArray3;
        axisName = new String[]{"ancestor", "ancestor-or-self", "attribute", "child", "descendant", "descendant-or-self", "following", "following-sibling", "namespace", "parent", "preceding", "preceding-sibling", "self", "preceding-or-ancestor"};
        axisJavaName = new String[]{"ANCESTOR", "ANCESTOR_OR_SELF", "ATTRIBUTE", "CHILD", "DESCENDANT", "DESCENDANT_OR_SELF", "FOLLOWING", "FOLLOWING_SIBLING", "NAMESPACE", "PARENT", "PRECEDING", "PRECEDING_SIBLING", "SELF", "PRECEDING_OR_ANCESTOR"};
        int[] nArray = new int[13];
        nArray[0] = 512;
        nArray[2] = 9100;
        nArray[3] = 8588;
        nArray[4] = 8588;
        nArray[6] = 512;
        nArray[7] = 8708;
        nArray[8] = 9100;
        nArray[9] = 512;
        nArray[10] = 512;
        nArray[11] = 8708;
        voidAxisTable = nArray;
        nodeKindTable = new int[]{514, 9102, 4, 394, 394, 9102, 394, 394, 8192, 514, 906, 394, 9102};
    }

    private Axis() {
    }

    public static byte getAxisNumber(String name) throws XPathException {
        if (name.equals("ancestor")) {
            return 0;
        }
        if (name.equals("ancestor-or-self")) {
            return 1;
        }
        if (name.equals("attribute")) {
            return 2;
        }
        if (name.equals("child")) {
            return 3;
        }
        if (name.equals("descendant")) {
            return 4;
        }
        if (name.equals("descendant-or-self")) {
            return 5;
        }
        if (name.equals("following")) {
            return 6;
        }
        if (name.equals("following-sibling")) {
            return 7;
        }
        if (name.equals("namespace")) {
            return 8;
        }
        if (name.equals("parent")) {
            return 9;
        }
        if (name.equals("preceding")) {
            return 10;
        }
        if (name.equals("preceding-sibling")) {
            return 11;
        }
        if (name.equals("self")) {
            return 12;
        }
        throw new XPathException("Unknown axis name: " + name);
    }

    public static boolean isAlwaysEmpty(int axis, int nodeKind) {
        return (voidAxisTable[axis] & 1 << nodeKind) != 0;
    }

    public static boolean containsNodeKind(int axis, int nodeKind) {
        return (nodeKindTable[axis] & 1 << nodeKind) != 0;
    }
}

