/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.java;

import java.text.Collator;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamSource;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.Platform;
import net2.sf.saxon.dom.DOMEnvelope;
import net2.sf.saxon.dom.DOMObjectModel;
import net2.sf.saxon.event.PipelineConfiguration;
import net2.sf.saxon.functions.FunctionLibraryList;
import net2.sf.saxon.java.JavaCollationFactory;
import net2.sf.saxon.sort.CodepointCollator;
import net2.sf.saxon.sort.NamedCollation;
import net2.sf.saxon.sort.StringCollator;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.SchemaType;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JavaPlatform
implements Platform {
    @Override
    public void initialize(Configuration config) {
        config.registerExternalObjectModel(DOMEnvelope.getInstance());
        config.registerExternalObjectModel(DOMObjectModel.getInstance());
    }

    @Override
    public boolean isJava() {
        return true;
    }

    @Override
    public boolean isDotNet() {
        return false;
    }

    @Override
    public String getVerifierClassName() {
        return "com.saxonica.config.Verifier";
    }

    @Override
    public String getPlatformVersion() {
        return "Java version " + System.getProperty("java.version");
    }

    @Override
    public String getPlatformSuffix() {
        return "J";
    }

    @Override
    public XMLReader loadParser() {
        XMLReader parser;
        try {
            parser = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException err) {
            throw new TransformerFactoryConfigurationError(err);
        }
        catch (SAXException err) {
            throw new TransformerFactoryConfigurationError(err);
        }
        return parser;
    }

    @Override
    public Source getParserSource(PipelineConfiguration pipe, StreamSource input, int validation, boolean dtdValidation, int stripspace) {
        return input;
    }

    @Override
    public StringCollator makeCollation(Configuration config, Properties props, String uri) throws XPathException {
        return JavaCollationFactory.makeCollation(config, uri, props);
    }

    @Override
    public boolean canReturnCollationKeys(StringCollator collation) {
        return collation instanceof CodepointCollator || collation instanceof NamedCollation && ((NamedCollation)collation).getCollation() instanceof Collator;
    }

    @Override
    public Object getCollationKey(NamedCollation namedCollation, String value) {
        return ((Collator)namedCollation.getCollation()).getCollationKey(value);
    }

    public void addFunctionLibraries(FunctionLibraryList list, Configuration config, int hostLanguage) {
    }

    @Override
    public SchemaType getExternalObjectType(Configuration config, String uri, String localName) {
        throw new UnsupportedOperationException("getExternalObjectType for Java");
    }
}

