/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.instruct;

import java.util.Arrays;
import java.util.List;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.PromotionOffer;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.instruct.GeneralVariable;
import net2.sf.saxon.instruct.TailCall;
import net2.sf.saxon.om.ValueRepresentation;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;

public class WithParam
extends GeneralVariable {
    int parameterId;
    boolean typeChecked = false;

    public void setParameterId(int id) {
        this.parameterId = id;
    }

    public void setTypeChecked(boolean checked) {
        this.typeChecked = checked;
    }

    public int getParameterId() {
        return this.parameterId;
    }

    @Override
    public int getInstructionNameCode() {
        return 188;
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        return null;
    }

    public static void simplify(WithParam[] params, ExpressionVisitor visitor) throws XPathException {
        int i = 0;
        while (i < params.length) {
            Expression select = params[i].getSelectExpression();
            if (select != null) {
                params[i].setSelectExpression(visitor.simplify(select));
            }
            ++i;
        }
    }

    public static void typeCheck(WithParam[] params, ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        int i = 0;
        while (i < params.length) {
            Expression select = params[i].getSelectExpression();
            if (select != null) {
                params[i].setSelectExpression(visitor.typeCheck(select, contextItemType));
            }
            ++i;
        }
    }

    public static void optimize(ExpressionVisitor visitor, WithParam[] params, ItemType contextItemType) throws XPathException {
        int i = 0;
        while (i < params.length) {
            visitor.optimize(params[i], contextItemType);
            ++i;
        }
    }

    public static void promoteParams(Expression parent, WithParam[] params, PromotionOffer offer) throws XPathException {
        int i = 0;
        while (i < params.length) {
            Expression select = params[i].getSelectExpression();
            if (select != null) {
                params[i].setSelectExpression(select.promote(offer, parent));
            }
            ++i;
        }
    }

    public static void getXPathExpressions(WithParam[] params, List list) {
        if (params != null) {
            list.addAll(Arrays.asList(params));
        }
    }

    public static void displayExpressions(WithParam[] params, ExpressionPresenter out) {
        if (params != null) {
            int i = 0;
            while (i < params.length) {
                out.startElement("withParam");
                out.emitAttribute("name", params[i].getVariableQName().getDisplayName());
                params[i].getSelectExpression().explain(out);
                out.endElement();
                ++i;
            }
        }
    }

    public static boolean replaceXPathExpression(WithParam[] params, Expression original, Expression replacement) {
        boolean found = false;
        int i = 0;
        while (i < params.length) {
            boolean f = params[i].replaceSubExpression(original, replacement);
            found |= f;
            ++i;
        }
        return found;
    }

    @Override
    public ValueRepresentation evaluateVariable(XPathContext context) throws XPathException {
        throw new UnsupportedOperationException();
    }

    public boolean isTypeChecked() {
        return this.typeChecked;
    }
}

