/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.instruct;

import java.util.Iterator;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.PairIterator;
import net2.sf.saxon.expr.PromotionOffer;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.instruct.Instruction;
import net2.sf.saxon.instruct.TailCall;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;

public class While
extends Instruction {
    private Expression test;
    private Expression action;

    public While(Expression test, Expression action) {
        this.test = test;
        this.action = action;
        this.adoptChildExpression(test);
        this.adoptChildExpression(action);
    }

    @Override
    public int getInstructionNameCode() {
        return 271;
    }

    public Expression getActionExpression() {
        return this.action;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.test = visitor.simplify(this.test);
        this.action = visitor.simplify(this.action);
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.test = visitor.typeCheck(this.test, contextItemType);
        this.adoptChildExpression(this.test);
        this.action = visitor.typeCheck(this.action, contextItemType);
        this.adoptChildExpression(this.action);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.test = visitor.optimize(this.test, contextItemType);
        this.adoptChildExpression(this.test);
        this.action = visitor.optimize(this.action, contextItemType);
        this.adoptChildExpression(this.action);
        return this;
    }

    @Override
    public Expression copy() {
        return new While(this.test.copy(), this.action.copy());
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return this.action.getItemType(th);
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        if (offer.action != 15) {
            this.test = this.doPromotion(this, this.test, offer);
        }
        this.action = this.doPromotion(this, this.action, offer);
    }

    @Override
    public final boolean createsNewNodes() {
        int props = this.action.getSpecialProperties();
        return (props & 0x400000) == 0;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new PairIterator(this.test, this.action);
    }

    @Override
    public boolean hasLoopingSubexpression(Expression child) {
        return child == this.action;
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.test == original) {
            this.test = replacement;
            found = true;
        }
        if (this.action == original) {
            this.action = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        while (this.test.effectiveBooleanValue(context)) {
            this.action.process(context);
        }
        return null;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("saxonWhile");
        this.test.explain(out);
        out.startSubsidiaryElement("do");
        this.action.explain(out);
        out.endSubsidiaryElement();
        out.endElement();
    }
}

