/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.instruct;

import java.util.Iterator;
import java.util.Stack;
import net2.sf.saxon.event.SequenceReceiver;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.expr.PairIterator;
import net2.sf.saxon.expr.PromotionOffer;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.functions.SystemFunction;
import net2.sf.saxon.instruct.DivisibleInstruction;
import net2.sf.saxon.om.FastStringBuffer;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.SingletonIterator;
import net2.sf.saxon.pattern.NodeKindTest;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.Cardinality;
import net2.sf.saxon.value.StringValue;
import net2.sf.saxon.value.Value;

public class SimpleContentConstructor
extends Expression
implements DivisibleInstruction {
    Expression select;
    Expression separator;
    boolean isSingleton = false;
    boolean isAtomic = false;

    public SimpleContentConstructor(Expression select, Expression separator) {
        this.select = select;
        this.separator = separator;
        this.adoptChildExpression(select);
        this.adoptChildExpression(separator);
        select.setFlattened(true);
    }

    public Expression getSelectExpression() {
        return this.select;
    }

    public Expression getSeparatorExpression() {
        return this.separator;
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }

    public boolean isAtomic() {
        return this.isAtomic;
    }

    @Override
    protected int computeCardinality() {
        return 16384;
    }

    @Override
    public Expression copy() {
        return new SimpleContentConstructor(this.select.copy(), this.separator.copy());
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.select = visitor.simplify(this.select);
        if (this.select instanceof Literal && ((Literal)this.select).getValue() instanceof AtomicValue) {
            return this.select;
        }
        this.separator = visitor.simplify(this.separator);
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        TypeHierarchy th;
        ItemType itemType;
        this.select = visitor.typeCheck(this.select, contextItemType);
        this.separator = visitor.typeCheck(this.separator, contextItemType);
        if (!Cardinality.allowsMany(this.select.getCardinality())) {
            this.isSingleton = true;
        }
        if ((itemType = this.select.getItemType(th = visitor.getConfiguration().getTypeHierarchy())).isAtomicType()) {
            this.isAtomic = true;
        }
        this.select.setFlattened(true);
        if (this.select instanceof Literal && this.separator instanceof Literal) {
            XPathContext c = visitor.getStaticContext().makeEarlyEvaluationContext();
            return new Literal(Value.asValue(this.evaluateItem(c)));
        }
        if (this.isSingleton) {
            boolean isUntyped;
            if (this.isAtomic) {
                if (th.isSubType(itemType, BuiltInAtomicType.STRING)) {
                    return this.select;
                }
                return SystemFunction.makeSystemFunction("string", new Expression[]{this.select});
            }
            boolean bl = isUntyped = !visitor.getExecutable().isSchemaAware();
            if (!isUntyped) {
                boolean maybeElement = th.relationship(itemType, NodeKindTest.ELEMENT) != 4;
                boolean maybeAttribute = th.relationship(itemType, NodeKindTest.ATTRIBUTE) != 4;
                boolean bl2 = isUntyped = !maybeElement && !maybeAttribute;
            }
            if (isUntyped) {
                return SystemFunction.makeSystemFunction("string", new Expression[]{this.select});
            }
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.select = visitor.optimize(this.select, contextItemType);
        this.separator = visitor.optimize(this.separator, contextItemType);
        if (this.select instanceof Literal && this.separator instanceof Literal) {
            XPathContext c = visitor.getStaticContext().makeEarlyEvaluationContext();
            return Literal.makeLiteral(Value.asValue(this.evaluateItem(c)));
        }
        return this;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.STRING;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("simpleContentConstructor");
        this.select.explain(out);
        this.separator.explain(out);
        out.endElement();
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new PairIterator(this.select, this.separator);
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        if (this.separator == original) {
            this.separator = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        this.select = this.doPromotion(this, this.select, offer);
        this.separator = this.doPromotion(this, this.separator, offer);
        return this;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        Item item;
        SequenceIterator iter;
        if (this.isSingleton) {
            Item item2 = this.select.evaluateItem(context);
            if (item2 == null || item2 instanceof StringValue) {
                return item2;
            }
            if (item2 instanceof AtomicValue) {
                return ((AtomicValue)item2).convert(BuiltInAtomicType.STRING, true, context).asAtomic();
            }
            iter = SingletonIterator.makeIterator(item2);
        } else {
            iter = this.select.iterate(context);
        }
        FastStringBuffer sb = new FastStringBuffer(64);
        boolean prevText = false;
        boolean first = true;
        CharSequence sep = null;
        while ((item = iter.next()) != null) {
            if (item instanceof NodeInfo) {
                Item item2;
                if (((NodeInfo)item).getNodeKind() == 3) {
                    CharSequence s = item.getStringValueCS();
                    if (s.length() <= 0) continue;
                    if (!first && !prevText) {
                        if (sep == null) {
                            sep = this.separator.evaluateItem(context).getStringValueCS();
                        }
                        sb.append(sep);
                    }
                    first = false;
                    sb.append(s);
                    prevText = true;
                    continue;
                }
                prevText = false;
                SequenceIterator iter2 = item.getTypedValue();
                while ((item2 = iter2.next()) != null) {
                    if (!first) {
                        if (sep == null) {
                            sep = this.separator.evaluateItem(context).getStringValueCS();
                        }
                        sb.append(sep);
                    }
                    first = false;
                    sb.append(item2.getStringValueCS());
                }
                continue;
            }
            if (!first) {
                if (sep == null) {
                    sep = this.separator.evaluateItem(context).getStringValueCS();
                }
                sb.append(sep);
            }
            first = false;
            prevText = false;
            sb.append(item.getStringValueCS());
        }
        return StringValue.makeStringValue(sb.condense());
    }

    public void process(XPathContext context, int locationId, int options) throws XPathException {
        SequenceReceiver out = context.getReceiver();
        if (this.isSingleton && this.isAtomic) {
            Item item = this.select.evaluateItem(context);
            if (item != null) {
                out.characters(item.getStringValueCS(), locationId, options);
            }
        } else {
            Item item;
            SequenceIterator iter = this.select.iterate(context);
            boolean prevText = false;
            boolean first = true;
            CharSequence sep = null;
            while ((item = iter.next()) != null) {
                if (item instanceof NodeInfo) {
                    Item item2;
                    if (((NodeInfo)item).getNodeKind() == 3) {
                        CharSequence s = item.getStringValueCS();
                        if (s.length() <= 0) continue;
                        if (!first && !prevText) {
                            if (sep == null) {
                                sep = this.separator.evaluateItem(context).getStringValueCS();
                            }
                            out.characters(sep, locationId, options);
                        }
                        first = false;
                        out.characters(s, locationId, options);
                        prevText = true;
                        continue;
                    }
                    prevText = false;
                    SequenceIterator iter2 = item.getTypedValue();
                    while ((item2 = iter2.next()) != null) {
                        if (!first) {
                            if (sep == null) {
                                sep = this.separator.evaluateItem(context).getStringValueCS();
                            }
                            out.characters(sep, locationId, options);
                        }
                        first = false;
                        out.characters(item2.getStringValueCS(), locationId, options);
                    }
                    continue;
                }
                if (!first) {
                    if (sep == null) {
                        sep = this.separator.evaluateItem(context).getStringValueCS();
                    }
                    out.characters(sep, locationId, options);
                }
                first = false;
                prevText = false;
                out.characters(item.getStringValueCS(), locationId, options);
            }
        }
    }

    @Override
    public void processLeft(Stack<XPathContext> contextStack, Stack state) throws XPathException {
    }

    @Override
    public void processRight(Stack<XPathContext> contextStack, Stack state) throws XPathException {
    }

    @Override
    public int getImplementationMethod() {
        return 1;
    }
}

