/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.instruct;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.om.NamespaceResolver;

public final class SavedNamespaceContext
implements Serializable,
NamespaceResolver {
    private int[] namespaceCodes;
    private NamePool namePool;

    public SavedNamespaceContext(int[] nscodes, NamePool pool) {
        this.namespaceCodes = nscodes;
        this.namePool = pool;
    }

    public SavedNamespaceContext(NamespaceResolver resolver, NamePool pool) {
        this.namePool = pool;
        ArrayList<Integer> list = new ArrayList<Integer>();
        Iterator<String> iter = resolver.iteratePrefixes();
        while (iter.hasNext()) {
            String prefix = iter.next();
            String uri = resolver.getURIForPrefix(prefix, true);
            int nscode = pool.getNamespaceCode(prefix, uri);
            list.add(new Integer(nscode));
        }
        this.namespaceCodes = new int[list.size()];
        int i = 0;
        while (i < list.size()) {
            this.namespaceCodes[i] = (Integer)list.get(i);
            ++i;
        }
    }

    public int[] getNamespaceCodes() {
        return this.namespaceCodes;
    }

    @Override
    public String getURIForPrefix(String prefix, boolean useDefault) {
        if (prefix.length() == 0 && !useDefault) {
            return "";
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        int prefixCode = this.namePool.getCodeForPrefix(prefix) << 16;
        int i = this.namespaceCodes.length - 1;
        while (i >= 0) {
            int nsCode = this.namespaceCodes[i];
            if ((nsCode & 0xFFFF0000) == prefixCode) {
                return this.namePool.getURIFromNamespaceCode(nsCode);
            }
            --i;
        }
        if (prefix.length() == 0) {
            return "";
        }
        return null;
    }

    public Iterator iteratePrefixes() {
        ArrayList<String> prefixes = new ArrayList<String>(this.namespaceCodes.length);
        int i = 0;
        while (i < this.namespaceCodes.length) {
            prefixes.add(this.namePool.getPrefixFromNamespaceCode(this.namespaceCodes[i]));
            ++i;
        }
        return prefixes.iterator();
    }
}

