/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.instruct;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import net2.sf.saxon.event.SequenceReceiver;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.expr.PromotionOffer;
import net2.sf.saxon.expr.RoleLocator;
import net2.sf.saxon.expr.StaticContext;
import net2.sf.saxon.expr.StringLiteral;
import net2.sf.saxon.expr.TypeChecker;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.instruct.SimpleNodeConstructor;
import net2.sf.saxon.pattern.NodeKindTest;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.Err;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.SequenceType;
import net2.sf.saxon.value.Whitespace;

public class ProcessingInstruction
extends SimpleNodeConstructor {
    private Expression name;

    public ProcessingInstruction(Expression name) {
        this.name = name;
        this.adoptChildExpression(name);
    }

    @Override
    public int getInstructionNameCode() {
        return 173;
    }

    public Expression getNameExpression() {
        return this.name;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return NodeKindTest.PROCESSING_INSTRUCTION;
    }

    @Override
    public int getCardinality() {
        return 16384;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.name = visitor.simplify(this.name);
        return super.simplify(visitor);
    }

    @Override
    public Expression copy() {
        ProcessingInstruction exp = new ProcessingInstruction(this.name.copy());
        try {
            exp.setSelect(this.select.copy(), this.getExecutable().getConfiguration());
        }
        catch (XPathException err) {
            throw new UnsupportedOperationException(err.getMessage());
        }
        return exp;
    }

    @Override
    public void localTypeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        String s2;
        String s;
        StaticContext env = visitor.getStaticContext();
        this.name = visitor.typeCheck(this.name, contextItemType);
        this.adoptChildExpression(this.name);
        RoleLocator role = new RoleLocator(4, (Serializable)((Object)"processing-instruction/name"), 0);
        this.name = TypeChecker.staticTypeCheck(this.name, SequenceType.SINGLE_STRING, false, role, visitor);
        this.adoptChildExpression(this.name);
        if (this.name instanceof Literal) {
            s = ((Literal)this.name).getValue().getStringValue();
            this.checkName(Whitespace.trim(s), env.makeEarlyEvaluationContext());
        }
        if (this.select instanceof Literal && !(s2 = this.checkContent(s = ((Literal)this.select).getValue().getStringValue(), env.makeEarlyEvaluationContext())).equals(s)) {
            this.setSelect(new StringLiteral(s2), env.getConfiguration());
        }
    }

    @Override
    public int getDependencies() {
        return this.name.getDependencies() | super.getDependencies();
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        ArrayList<Expression> list = new ArrayList<Expression>(6);
        if (this.select != null) {
            list.add(this.select);
        }
        list.add(this.name);
        return list.iterator();
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        if (this.name == original) {
            this.name = replacement;
            found = true;
        }
        return found;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        this.name = this.doPromotion(this, this.name, offer);
        super.promoteInst(offer);
    }

    @Override
    public void processValue(CharSequence value, XPathContext context) throws XPathException {
        String expandedName = this.evaluateName(context);
        if (expandedName != null) {
            String data = this.checkContent(value.toString(), context);
            SequenceReceiver out = context.getReceiver();
            out.processingInstruction(expandedName, data, this.locationId, 0);
        }
    }

    @Override
    protected String checkContent(String data, XPathContext context) throws XPathException {
        int hh;
        while ((hh = data.indexOf("?>")) >= 0) {
            if (this.isXSLT()) {
                data = String.valueOf(data.substring(0, hh + 1)) + ' ' + data.substring(hh + 1);
                continue;
            }
            XPathException err = new XPathException("Invalid characters (?>) in processing instruction", this);
            err.setErrorCode("XQDY0026");
            err.setXPathContext(context);
            throw ProcessingInstruction.dynamicError(this, err, context);
        }
        data = Whitespace.removeLeadingWhitespace(data).toString();
        return data;
    }

    @Override
    public int evaluateNameCode(XPathContext context) throws XPathException {
        String expandedName = this.evaluateName(context);
        return context.getNamePool().allocate("", "", expandedName);
    }

    private String evaluateName(XPathContext context) throws XPathException {
        String expandedName;
        try {
            expandedName = Whitespace.trim(this.name.evaluateAsString(context));
        }
        catch (ClassCastException err) {
            XPathException e = new XPathException("Processing instruction name is not a string");
            e.setXPathContext(context);
            e.setErrorCode("XQDY0041");
            throw ProcessingInstruction.dynamicError(this, e, context);
        }
        this.checkName(expandedName, context);
        return expandedName;
    }

    private void checkName(String expandedName, XPathContext context) throws XPathException {
        if (!context.getConfiguration().getNameChecker().isValidNCName(expandedName)) {
            XPathException e = new XPathException("Processing instruction name " + Err.wrap(expandedName) + " is not a valid NCName");
            e.setXPathContext(context);
            e.setErrorCode(this.isXSLT() ? "XTDE0890" : "XQDY0041");
            throw ProcessingInstruction.dynamicError(this, e, context);
        }
        if (expandedName.equalsIgnoreCase("xml")) {
            XPathException e = new XPathException("Processing instructions cannot be named 'xml' in any combination of upper/lower case");
            e.setXPathContext(context);
            e.setErrorCode(this.isXSLT() ? "XTDE0890" : "XQDY0064");
            throw ProcessingInstruction.dynamicError(this, e, context);
        }
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("processingInstruction");
        out.startSubsidiaryElement("name");
        this.name.explain(out);
        out.endSubsidiaryElement();
        out.startSubsidiaryElement("select");
        this.getSelect().explain(out);
        out.endSubsidiaryElement();
        out.endElement();
    }
}

