/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.instruct;

import java.util.Arrays;
import net2.sf.saxon.Controller;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.expr.XPathContextMajor;
import net2.sf.saxon.instruct.ApplyImports;
import net2.sf.saxon.instruct.ApplyTemplates;
import net2.sf.saxon.instruct.ParameterSet;
import net2.sf.saxon.instruct.TailCall;
import net2.sf.saxon.instruct.Template;
import net2.sf.saxon.instruct.WithParam;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.Mode;
import net2.sf.saxon.trans.Rule;
import net2.sf.saxon.trans.XPathException;

public class NextMatch
extends ApplyImports {
    boolean useTailRecursion;

    public NextMatch(boolean useTailRecursion) {
        this.useTailRecursion = useTailRecursion;
    }

    @Override
    public int getInstructionNameCode() {
        return 159;
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        ParameterSet params = NextMatch.assembleParams(context, this.actualParams);
        ParameterSet tunnels = NextMatch.assembleTunnelParams(context, this.tunnelParams);
        Rule currentRule = context.getCurrentTemplateRule();
        if (currentRule == null) {
            XPathException e = new XPathException("There is no current template rule");
            e.setXPathContext(context);
            e.setErrorCode("XTDE0560");
            throw e;
        }
        Mode mode = context.getCurrentMode();
        if (mode == null) {
            mode = controller.getRuleManager().getDefaultMode();
        }
        if (context.getCurrentIterator() == null) {
            XPathException e = new XPathException("There is no context item");
            e.setXPathContext(context);
            e.setErrorCode("XTDE0565");
            throw e;
        }
        Item currentItem = context.getCurrentIterator().current();
        if (!(currentItem instanceof NodeInfo)) {
            XPathException e = new XPathException("Cannot call xsl:next-match when context item is not a node");
            e.setXPathContext(context);
            e.setErrorCode("XTDE0565");
            throw e;
        }
        NodeInfo node = (NodeInfo)currentItem;
        Rule rule = controller.getRuleManager().getNextMatchHandler(node, mode, currentRule, context);
        if (rule == null) {
            ApplyTemplates.defaultAction(node, params, tunnels, context, this.getLocationId());
        } else {
            if (this.useTailRecursion) {
                Arrays.fill(context.getStackFrame().getStackFrameValues(), null);
                return new NextMatchPackage(rule, params, tunnels, context);
            }
            Template nh = (Template)rule.getAction();
            XPathContextMajor c2 = context.newContext();
            c2.setOrigin(this);
            c2.setOriginatingConstructType(2008);
            c2.openStackFrame(nh.getStackFrameMap());
            c2.setLocalParameters(params);
            c2.setTunnelParameters(tunnels);
            c2.setCurrentTemplateRule(rule);
            nh.apply(c2);
        }
        return null;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("nextMatch");
        if (this.actualParams != null && this.actualParams.length > 0) {
            out.startSubsidiaryElement("withParams");
            WithParam.displayExpressions(this.actualParams, out);
            out.endSubsidiaryElement();
        }
        if (this.tunnelParams != null && this.tunnelParams.length > 0) {
            out.startSubsidiaryElement("tunnelParams");
            WithParam.displayExpressions(this.tunnelParams, out);
            out.endSubsidiaryElement();
        }
        out.endElement();
    }

    private class NextMatchPackage
    implements TailCall {
        private Rule rule;
        private ParameterSet params;
        private ParameterSet tunnelParams;
        private XPathContext evaluationContext;

        public NextMatchPackage(Rule rule, ParameterSet params, ParameterSet tunnelParams, XPathContext evaluationContext) {
            this.rule = rule;
            this.params = params;
            this.tunnelParams = tunnelParams;
            this.evaluationContext = evaluationContext;
        }

        @Override
        public TailCall processLeavingTail() throws XPathException {
            Template nh = (Template)this.rule.getAction();
            XPathContextMajor c2 = this.evaluationContext.newContext();
            c2.setOrigin(NextMatch.this);
            c2.setOriginatingConstructType(2008);
            c2.setLocalParameters(this.params);
            c2.setTunnelParameters(this.tunnelParams);
            c2.openStackFrame(nh.getStackFrameMap());
            c2.setCurrentTemplateRule(this.rule);
            return nh.applyLeavingTail(c2);
        }
    }
}

