/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.instruct;

import javax.xml.transform.SourceLocator;
import net2.sf.saxon.Controller;
import net2.sf.saxon.event.PipelineConfiguration;
import net2.sf.saxon.event.SequenceOutputter;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.PromotionOffer;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.expr.XPathContextMinor;
import net2.sf.saxon.instruct.ParameterSet;
import net2.sf.saxon.instruct.TailCall;
import net2.sf.saxon.instruct.TailCallReturner;
import net2.sf.saxon.instruct.TerminationException;
import net2.sf.saxon.instruct.WithParam;
import net2.sf.saxon.om.EmptyIterator;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.SingletonIterator;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.Type;
import net2.sf.saxon.type.TypeHierarchy;

public abstract class Instruction
extends Expression
implements SourceLocator,
TailCallReturner {
    @Override
    public int getImplementationMethod() {
        return 4;
    }

    public int getInstructionNameCode() {
        return -1;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return Type.ITEM_TYPE;
    }

    @Override
    public int computeCardinality() {
        return 57344;
    }

    @Override
    public abstract TailCall processLeavingTail(XPathContext var1) throws XPathException;

    @Override
    public void process(XPathContext context) throws XPathException {
        try {
            TailCall tc = this.processLeavingTail(context);
            while (tc != null) {
                tc = tc.processLeavingTail();
            }
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            throw err;
        }
    }

    public SourceLocator getSourceLocator() {
        return this;
    }

    protected static XPathException dynamicError(SourceLocator loc, XPathException error, XPathContext context) {
        if (error instanceof TerminationException) {
            return error;
        }
        error.maybeSetLocation(loc);
        error.maybeSetContext(context);
        return error;
    }

    protected static ParameterSet assembleParams(XPathContext context, WithParam[] actualParams) throws XPathException {
        if (actualParams == null || actualParams.length == 0) {
            return null;
        }
        ParameterSet params = new ParameterSet(actualParams.length);
        int i = 0;
        while (i < actualParams.length) {
            params.put(actualParams[i].getParameterId(), actualParams[i].getSelectValue(context), actualParams[i].isTypeChecked());
            ++i;
        }
        return params;
    }

    protected static ParameterSet assembleTunnelParams(XPathContext context, WithParam[] actualParams) throws XPathException {
        ParameterSet existingParams = context.getTunnelParameters();
        if (existingParams == null) {
            return Instruction.assembleParams(context, actualParams);
        }
        ParameterSet newParams = new ParameterSet(existingParams, actualParams == null ? 0 : actualParams.length);
        if (actualParams == null || actualParams.length == 0) {
            return newParams;
        }
        int i = 0;
        while (i < actualParams.length) {
            newParams.put(actualParams[i].getParameterId(), actualParams[i].getSelectValue(context), false);
            ++i;
        }
        return newParams;
    }

    @Override
    public abstract Expression simplify(ExpressionVisitor var1) throws XPathException;

    @Override
    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        if (this.createsNewNodes()) {
            return p;
        }
        return p | 0x400000;
    }

    public boolean createsNewNodes() {
        return false;
    }

    protected void promoteInst(PromotionOffer offer) throws XPathException {
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        this.promoteInst(offer);
        return this;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        int m = this.getImplementationMethod();
        if ((m & 1) != 0) {
            throw new AssertionError((Object)("evaluateItem() is not implemented in the subclass " + this.getClass()));
        }
        if ((m & 2) != 0) {
            return this.iterate(context).next();
        }
        Controller controller = context.getController();
        XPathContextMinor c2 = context.newMinorContext();
        c2.setOrigin(this);
        SequenceOutputter seq = controller.allocateSequenceOutputter(1);
        PipelineConfiguration pipe = controller.makePipelineConfiguration();
        pipe.setHostLanguage(this.getHostLanguage());
        seq.setPipelineConfiguration(pipe);
        c2.setTemporaryReceiver(seq);
        this.process(c2);
        seq.close();
        Item result = seq.getFirstItem();
        seq.reset();
        return result;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        int m = this.getImplementationMethod();
        if ((m & 1) != 0) {
            Item item = this.evaluateItem(context);
            if (item == null) {
                return EmptyIterator.getInstance();
            }
            return SingletonIterator.makeIterator(item);
        }
        if ((m & 2) != 0) {
            throw new AssertionError((Object)("iterate() is not implemented in the subclass " + this.getClass()));
        }
        Controller controller = context.getController();
        XPathContextMinor c2 = context.newMinorContext();
        c2.setOrigin(this);
        SequenceOutputter seq = controller.allocateSequenceOutputter(20);
        PipelineConfiguration pipe = controller.makePipelineConfiguration();
        pipe.setHostLanguage(this.getHostLanguage());
        seq.setPipelineConfiguration(pipe);
        c2.setTemporaryReceiver(seq);
        this.process(c2);
        seq.close();
        return seq.iterate();
    }

    @Override
    public final CharSequence evaluateAsString(XPathContext context) throws XPathException {
        Item item = this.evaluateItem(context);
        if (item == null) {
            return "";
        }
        return item.getStringValue();
    }

    @Override
    public int getConstructType() {
        return this.getInstructionNameCode();
    }

    public boolean isXSLT() {
        return this.getHostLanguage() == 50;
    }
}

