/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.instruct;

import java.util.Collections;
import java.util.Iterator;
import net2.sf.saxon.expr.Binding;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionTool;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.MonoIterator;
import net2.sf.saxon.expr.PromotionOffer;
import net2.sf.saxon.expr.RoleLocator;
import net2.sf.saxon.expr.TypeChecker;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.instruct.Instruction;
import net2.sf.saxon.om.EmptyIterator;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.StructuredQName;
import net2.sf.saxon.om.ValueRepresentation;
import net2.sf.saxon.pattern.EmptySequenceTest;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.SequenceType;

public abstract class GeneralVariable
extends Instruction
implements Binding {
    private static final int ASSIGNABLE = 1;
    private static final int REQUIRED = 4;
    private static final int TUNNEL = 8;
    private static final int IMPLICITLY_REQUIRED = 16;
    private byte properties = 0;
    Expression select = null;
    protected StructuredQName variableQName;
    SequenceType requiredType;
    protected int slotNumber;
    protected int referenceCount = 10;
    protected int evaluationMode = -1;

    public void init(Expression select, StructuredQName qName) {
        this.select = select;
        this.variableQName = qName;
        this.adoptChildExpression(select);
    }

    public void setSelectExpression(Expression select) {
        this.select = select;
        this.evaluationMode = -1;
        this.adoptChildExpression(select);
    }

    public Expression getSelectExpression() {
        return this.select;
    }

    public void setRequiredType(SequenceType required) {
        this.requiredType = required;
    }

    @Override
    public SequenceType getRequiredType() {
        return this.requiredType;
    }

    public void setAssignable(boolean assignable) {
        this.properties = assignable ? (byte)(this.properties | 1) : (byte)(this.properties & 0xFFFFFFFE);
    }

    public void setRequiredParam(boolean requiredParam) {
        this.properties = requiredParam ? (byte)(this.properties | 4) : (byte)(this.properties & 0xFFFFFFFB);
    }

    public void setImplicitlyRequiredParam(boolean requiredParam) {
        this.properties = requiredParam ? (byte)(this.properties | 0x10) : (byte)(this.properties & 0xFFFFFFEF);
    }

    public void setTunnel(boolean tunnel) {
        this.properties = tunnel ? (byte)(this.properties | 8) : (byte)(this.properties & 0xFFFFFFF7);
    }

    public void setReferenceCount(int refCount) {
        this.referenceCount = refCount;
    }

    public int getEvaluationMode() {
        if (this.evaluationMode == -1 && this.referenceCount == 10000) {
            this.evaluationMode = 12;
        }
        return this.evaluationMode;
    }

    @Override
    public final boolean isAssignable() {
        return (this.properties & 1) != 0;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return EmptySequenceTest.getInstance();
    }

    @Override
    public int getCardinality() {
        return 8192;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public int getLocalSlotNumber() {
        return this.slotNumber;
    }

    public final boolean isRequiredParam() {
        return (this.properties & 4) != 0;
    }

    public final boolean isImplicitlyRequiredParam() {
        return (this.properties & 0x10) != 0;
    }

    public final boolean isTunnelParam() {
        return (this.properties & 8) != 0;
    }

    @Override
    public int getInstructionNameCode() {
        return 185;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        if (this.select != null) {
            this.select = visitor.simplify(this.select);
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        if (this.select != null) {
            this.select = visitor.typeCheck(this.select, contextItemType);
            this.adoptChildExpression(this.select);
        }
        this.checkAgainstRequiredType(visitor);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        if (this.select != null) {
            this.select = visitor.optimize(this.select, contextItemType);
            this.adoptChildExpression(this.select);
            this.evaluationMode = this.computeEvaluationMode();
        }
        return this;
    }

    private int computeEvaluationMode() {
        if (this.isAssignable()) {
            return ExpressionTool.eagerEvaluationMode(this.select);
        }
        if (this.referenceCount == 10000) {
            return 12;
        }
        return ExpressionTool.lazyEvaluationMode(this.select);
    }

    @Override
    public Expression copy() {
        throw new UnsupportedOperationException("copy");
    }

    private void checkAgainstRequiredType(ExpressionVisitor visitor) throws XPathException {
        RoleLocator role = new RoleLocator(3, this.variableQName, 0);
        SequenceType r = this.requiredType;
        if (r != null && this.select != null) {
            this.select = TypeChecker.staticTypeCheck(this.select, this.requiredType, false, role, visitor);
        }
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        this.process(context);
        return null;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        this.evaluateItem(context);
        return EmptyIterator.getInstance();
    }

    public ValueRepresentation getSelectValue(XPathContext context) throws XPathException {
        if (this.select == null) {
            throw new AssertionError((Object)"*** No select expression!!");
        }
        return ExpressionTool.evaluate(this.select, this.evaluationMode, context, this.referenceCount);
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        Expression e2;
        if (this.select != null && (e2 = this.doPromotion(this, this.select, offer)) != this.select) {
            this.select = e2;
            this.evaluationMode = this.computeEvaluationMode();
        }
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        if (this.select != null) {
            return new MonoIterator(this.select);
        }
        return Collections.EMPTY_LIST.iterator();
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("variable");
        out.emitAttribute("name", this.variableQName.getDisplayName());
        if (this.select != null) {
            this.select.explain(out);
        }
        out.endElement();
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public void setSlotNumber(int s) {
        this.slotNumber = s;
    }

    public void setVariableQName(StructuredQName s) {
        this.variableQName = s;
    }

    @Override
    public StructuredQName getVariableQName() {
        return this.variableQName;
    }
}

