/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.instruct;

import java.util.Iterator;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.event.Receiver;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.StaticContext;
import net2.sf.saxon.expr.StringLiteral;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.instruct.Block;
import net2.sf.saxon.instruct.ElementCreator;
import net2.sf.saxon.instruct.FixedAttribute;
import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.om.QNameException;
import net2.sf.saxon.om.Validation;
import net2.sf.saxon.pattern.CombinedNodeTest;
import net2.sf.saxon.pattern.ContentTypeTest;
import net2.sf.saxon.pattern.NameTest;
import net2.sf.saxon.pattern.NodeKindTest;
import net2.sf.saxon.pattern.NodeTest;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.AnyType;
import net2.sf.saxon.type.ComplexType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.SchemaDeclaration;
import net2.sf.saxon.type.SchemaException;
import net2.sf.saxon.type.SchemaType;
import net2.sf.saxon.type.SimpleType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.type.Untyped;
import net2.sf.saxon.type.ValidationException;

public class FixedElement
extends ElementCreator {
    private int nameCode;
    protected int[] namespaceCodes = null;
    private ItemType itemType;

    public FixedElement(int nameCode, int[] namespaceCodes, boolean inheritNamespaces, SchemaType schemaType, int validation) {
        this.nameCode = nameCode;
        this.namespaceCodes = namespaceCodes;
        this.inheritNamespaces = inheritNamespaces;
        this.setSchemaType(schemaType);
        this.validation = validation;
        this.preservingTypes = schemaType == null && validation == 3;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        Configuration config = visitor.getConfiguration();
        this.setLazyConstruction(config.isLazyConstructionMode());
        this.preservingTypes |= !config.isLicensedFeature(1);
        return super.simplify(visitor);
    }

    @Override
    protected void checkContentSequence(StaticContext env) throws XPathException {
        super.checkContentSequence(env);
        this.itemType = this.computeFixedElementItemType(this, env, this.validation, this.getSchemaType(), this.nameCode, this.content);
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression e = super.optimize(visitor, contextItemType);
        if (e != this) {
            return e;
        }
        if (!this.inheritNamespaces) {
            return this;
        }
        if (this.namespaceCodes == null || this.namespaceCodes.length == 0) {
            return this;
        }
        NamePool pool = visitor.getExecutable().getConfiguration().getNamePool();
        short uriCode = this.getURICode(pool);
        if (this.content instanceof FixedElement) {
            if (((FixedElement)this.content).getURICode(pool) == uriCode) {
                ((FixedElement)this.content).removeRedundantNamespaces(visitor, this.namespaceCodes);
            }
            return this;
        }
        if (this.content instanceof Block) {
            Iterator<Expression> iter = this.content.iterateSubExpressions();
            while (iter.hasNext()) {
                Expression exp = iter.next();
                if (!(exp instanceof FixedElement) || ((FixedElement)exp).getURICode(pool) != uriCode) continue;
                ((FixedElement)exp).removeRedundantNamespaces(visitor, this.namespaceCodes);
            }
        }
        return this;
    }

    private void removeRedundantNamespaces(ExpressionVisitor visitor, int[] parentNamespaces) {
        ItemType contentType;
        boolean ok;
        if (this.namespaceCodes == null || this.namespaceCodes.length == 0) {
            return;
        }
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        boolean bl = ok = th.relationship(contentType = this.content.getItemType(th), NodeKindTest.ATTRIBUTE) == 4;
        if (!ok && this.content instanceof Block) {
            ok = true;
            Iterator<Expression> iter = this.content.iterateSubExpressions();
            while (iter.hasNext()) {
                Expression exp = iter.next();
                if (exp instanceof FixedAttribute) {
                    int attNameCode = ((FixedAttribute)exp).getAttributeNameCode();
                    if (!NamePool.isPrefixed(attNameCode)) continue;
                    ok = false;
                    break;
                }
                ItemType childType = exp.getItemType(th);
                if (th.relationship(childType, NodeKindTest.ATTRIBUTE) == 4) continue;
                ok = false;
                break;
            }
        }
        if (ok) {
            int j;
            int removed = 0;
            int i = 0;
            while (i < this.namespaceCodes.length) {
                j = 0;
                while (j < parentNamespaces.length) {
                    if (this.namespaceCodes[i] == parentNamespaces[j]) {
                        this.namespaceCodes[i] = -1;
                        ++removed;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            if (removed > 0) {
                if (removed == this.namespaceCodes.length) {
                    this.namespaceCodes = null;
                } else {
                    int[] ns2 = new int[this.namespaceCodes.length - removed];
                    j = 0;
                    int i2 = 0;
                    while (i2 < this.namespaceCodes.length) {
                        if (this.namespaceCodes[i2] != -1) {
                            ns2[j++] = this.namespaceCodes[i2];
                        }
                        ++i2;
                    }
                    this.namespaceCodes = ns2;
                }
            }
        }
    }

    @Override
    public Expression copy() {
        FixedElement fe = new FixedElement(this.nameCode, this.namespaceCodes, this.inheritNamespaces, this.getSchemaType(), this.validation);
        fe.setContentExpression(this.content.copy());
        fe.setBaseURI(this.getBaseURI());
        return fe;
    }

    public short getURICode(NamePool pool) {
        return pool.getURICode(this.nameCode);
    }

    private ItemType computeFixedElementItemType(FixedElement instr, StaticContext env, int validation, SchemaType schemaType, int nameCode, Expression content) throws XPathException {
        NodeTest itemType;
        Configuration config = env.getConfiguration();
        if (schemaType == null) {
            if (validation == 1) {
                SchemaDeclaration decl = config.getElementDeclaration(nameCode & 0xFFFFF);
                if (decl == null) {
                    XPathException err = new XPathException("There is no global element declaration for " + env.getNamePool().getDisplayName(nameCode) + ", so strict validation will fail");
                    err.setErrorCode(instr.isXSLT() ? "XTTE1512" : "XQDY0027");
                    err.setIsTypeError(true);
                    err.setLocator(instr);
                    throw err;
                }
                if (decl.isAbstract()) {
                    XPathException err = new XPathException("The element declaration for " + env.getNamePool().getDisplayName(nameCode) + " is abstract, so strict validation will fail");
                    err.setErrorCode(instr.isXSLT() ? "XTTE1512" : "XQDY0027");
                    err.setIsTypeError(true);
                    err.setLocator(instr);
                    throw err;
                }
                schemaType = decl.getType();
                instr.setSchemaType(schemaType);
                itemType = new CombinedNodeTest(new NameTest(1, nameCode, env.getNamePool()), 23, new ContentTypeTest(1, schemaType, config));
                try {
                    schemaType.analyzeContentExpression(content, 1, env);
                }
                catch (XPathException e) {
                    e.setErrorCode(instr.isXSLT() ? "XTTE1510" : "XQDY0027");
                    e.setLocator(instr);
                    throw e;
                }
                SchemaType xsiType = instr.getXSIType(env);
                if (xsiType != null) {
                    xsiType.analyzeContentExpression(content, 1, env);
                    try {
                        config.checkTypeDerivationIsOK(xsiType, schemaType, 0);
                    }
                    catch (SchemaException e) {
                        ValidationException ve = new ValidationException("The specified xsi:type " + xsiType.getDescription() + " is not validly derived from the required type " + schemaType.getDescription());
                        ve.setConstraintReference(1, "cvc-elt", "4.3");
                        ve.setErrorCode(instr.isXSLT() ? "XTTE1515" : "XQDY0027");
                        ve.setLocator(instr);
                        throw ve;
                    }
                }
            } else if (validation == 2) {
                SchemaDeclaration decl = config.getElementDeclaration(nameCode & 0xFFFFF);
                if (decl == null) {
                    env.issueWarning("There is no global element declaration for " + env.getNamePool().getDisplayName(nameCode), instr);
                    itemType = new NameTest(1, nameCode, env.getNamePool());
                } else {
                    schemaType = decl.getType();
                    instr.setSchemaType(schemaType);
                    itemType = new CombinedNodeTest(new NameTest(1, nameCode, env.getNamePool()), 23, new ContentTypeTest(1, instr.getSchemaType(), config));
                    try {
                        schemaType.analyzeContentExpression(content, 1, env);
                    }
                    catch (XPathException e) {
                        e.setErrorCode(instr.isXSLT() ? "XTTE1515" : "XQDY0027");
                        e.setLocator(instr);
                        throw e;
                    }
                }
            } else {
                itemType = validation == 3 ? new CombinedNodeTest(new NameTest(1, nameCode, env.getNamePool()), 23, new ContentTypeTest(1, AnyType.getInstance(), config)) : new CombinedNodeTest(new NameTest(1, nameCode, env.getNamePool()), 23, new ContentTypeTest(1, Untyped.getInstance(), config));
            }
        } else {
            itemType = new CombinedNodeTest(new NameTest(1, nameCode, env.getNamePool()), 23, new ContentTypeTest(1, schemaType, config));
            try {
                schemaType.analyzeContentExpression(content, 1, env);
            }
            catch (XPathException e) {
                e.setErrorCode(instr.isXSLT() ? "XTTE1540" : "XQDY0027");
                e.setLocator(instr);
                throw e;
            }
        }
        return itemType;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        if (this.itemType == null) {
            return super.getItemType(th);
        }
        return this.itemType;
    }

    @Override
    public int getNameCode(XPathContext context) {
        return this.nameCode;
    }

    @Override
    public String getNewBaseURI(XPathContext context) {
        return this.getBaseURI();
    }

    private SchemaType getXSIType(StaticContext env) throws XPathException {
        if (this.content instanceof FixedAttribute) {
            return this.testForXSIType((FixedAttribute)this.content, env);
        }
        if (this.content instanceof Block) {
            Iterator<Expression> iter = this.content.iterateSubExpressions();
            while (iter.hasNext()) {
                SchemaType type;
                Expression exp = iter.next();
                if (!(exp instanceof FixedAttribute) || (type = this.testForXSIType((FixedAttribute)exp, env)) == null) continue;
                return type;
            }
            return null;
        }
        return null;
    }

    private SchemaType testForXSIType(FixedAttribute fat, StaticContext env) throws XPathException {
        Expression attValue;
        int att = fat.getAttributeNameCode() & 0xFFFFF;
        if (att == 641 && (attValue = fat.getSelect()) instanceof StringLiteral) {
            int uriCode;
            String[] parts;
            NamePool pool;
            block6: {
                try {
                    pool = env.getNamePool();
                    parts = env.getConfiguration().getNameChecker().getQNameParts(((StringLiteral)attValue).getStringValue());
                    uriCode = -1;
                    int n = 0;
                    while (n < this.namespaceCodes.length) {
                        String prefix = pool.getPrefixFromNamespaceCode(this.namespaceCodes[n]);
                        if (prefix.equals(parts[0])) {
                            uriCode = this.namespaceCodes[n] & 0xFFFF;
                            break;
                        }
                        ++n;
                    }
                    if (uriCode != -1) break block6;
                    return null;
                }
                catch (QNameException e) {
                    throw new XPathException(e.getMessage());
                }
            }
            String uri = pool.getURIFromURICode((short)uriCode);
            int typefp = pool.allocate(parts[0], uri, parts[1]) & 0xFFFFF;
            return env.getConfiguration().getSchemaType(typefp);
        }
        return null;
    }

    @Override
    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        SchemaType type;
        if (parentType instanceof SimpleType) {
            XPathException err = new XPathException("Element " + env.getNamePool().getDisplayName(this.nameCode) + " is not permitted here: the containing element is of simple type " + parentType.getDescription());
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
        if (((ComplexType)parentType).isSimpleContent()) {
            XPathException err = new XPathException("Element " + env.getNamePool().getDisplayName(this.nameCode) + " is not permitted here: the containing element has a complex type with simple content");
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
        if (whole) {
            Block block = new Block();
            block.setChildren(new Expression[]{this});
            parentType.analyzeContentExpression(block, 1, env);
        }
        try {
            type = ((ComplexType)parentType).getElementParticleType(this.nameCode & 0xFFFFF, true);
        }
        catch (SchemaException e) {
            throw new XPathException(e);
        }
        if (type == null) {
            XPathException err = new XPathException("Element " + env.getNamePool().getDisplayName(this.nameCode) + " is not permitted in the content model of the complex type " + parentType.getDescription());
            err.setIsTypeError(true);
            err.setLocator(this);
            err.setErrorCode(this.isXSLT() ? "XTTE1510" : "XQDY0027");
            throw err;
        }
        if (type instanceof AnyType) {
            return;
        }
        try {
            this.content.checkPermittedContents(type, env, true);
        }
        catch (XPathException e) {
            if (e.getLocator() == null || e.getLocator() == e) {
                e.setLocator(this);
            }
            throw e;
        }
    }

    @Override
    protected void outputNamespaceNodes(XPathContext context, Receiver out, int nameCode) throws XPathException {
        if (this.namespaceCodes != null) {
            int i = 0;
            while (i < this.namespaceCodes.length) {
                out.namespace(this.namespaceCodes[i], 0);
                ++i;
            }
        }
    }

    @Override
    public int[] getActiveNamespaces() {
        return this.namespaceCodes;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("directElement");
        out.emitAttribute("name", out.getNamePool().getClarkName(this.nameCode));
        out.emitAttribute("validation", Validation.toString(this.validation));
        if (this.getSchemaType() != null) {
            out.emitAttribute("type", this.getSchemaType().getDescription());
        }
        this.content.explain(out);
        out.endElement();
    }
}

