/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.instruct;

import java.util.Stack;
import net2.sf.saxon.Controller;
import net2.sf.saxon.event.PipelineConfiguration;
import net2.sf.saxon.event.Receiver;
import net2.sf.saxon.event.SequenceOutputter;
import net2.sf.saxon.event.SequenceReceiver;
import net2.sf.saxon.event.TreeReceiver;
import net2.sf.saxon.evpull.BracketedElementIterator;
import net2.sf.saxon.evpull.EndElementEvent;
import net2.sf.saxon.evpull.EventAnnotationStripper;
import net2.sf.saxon.evpull.EventIterator;
import net2.sf.saxon.evpull.SingletonEventIterator;
import net2.sf.saxon.evpull.StartElementEvent;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.StaticContext;
import net2.sf.saxon.expr.StringLiteral;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.expr.XPathContextMinor;
import net2.sf.saxon.instruct.Block;
import net2.sf.saxon.instruct.ParentNodeConstructor;
import net2.sf.saxon.instruct.TailCall;
import net2.sf.saxon.instruct.ValueOf;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.pattern.NodeKindTest;
import net2.sf.saxon.pattern.NodeTest;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.type.ValidationException;
import net2.sf.saxon.value.Cardinality;

public abstract class ElementCreator
extends ParentNodeConstructor {
    protected boolean inheritNamespaces = true;
    protected boolean preservingTypes = true;

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return NodeKindTest.ELEMENT;
    }

    public boolean isPreservingTypes() {
        return this.preservingTypes;
    }

    public boolean isInheritNamespaces() {
        return this.inheritNamespaces;
    }

    @Override
    public int computeSpecialProperties() {
        return super.computeSpecialProperties() | 0x800000;
    }

    @Override
    public void setValidationMode(int mode) {
        super.setValidationMode(mode);
        if (mode != 3) {
            this.preservingTypes = false;
        }
    }

    @Override
    public void suppressValidation(int validationMode) {
        if (this.validation == validationMode) {
            this.setValidationMode(3);
        }
    }

    @Override
    protected void checkContentSequence(StaticContext env) throws XPathException {
        if (this.content instanceof Block) {
            TypeHierarchy th = env.getConfiguration().getTypeHierarchy();
            Expression[] components = ((Block)this.content).getChildren();
            boolean foundChild = false;
            boolean foundPossibleChild = false;
            int childNodeKinds = 394;
            int i = 0;
            while (i < components.length) {
                ItemType it = components[i].getItemType(th);
                if (it instanceof NodeTest) {
                    boolean maybeEmpty = Cardinality.allowsZero(components[i].getCardinality());
                    int possibleNodeKinds = ((NodeTest)it).getNodeKindMask();
                    if ((possibleNodeKinds & 8) != 0) {
                        if (components[i] instanceof ValueOf && ((ValueOf)components[i]).select instanceof StringLiteral) {
                            String value = ((StringLiteral)((ValueOf)components[i]).select).getStringValue();
                            if (value.length() != 0) {
                                foundChild = true;
                            }
                        } else {
                            foundPossibleChild = true;
                        }
                    } else if ((possibleNodeKinds & ~childNodeKinds) == 0) {
                        if (maybeEmpty) {
                            foundPossibleChild = true;
                        } else {
                            foundChild = true;
                        }
                    } else {
                        XPathException de;
                        if (foundChild && possibleNodeKinds == 4 && !maybeEmpty) {
                            de = new XPathException("Cannot create an attribute node after creating a child of the containing element");
                            de.setErrorCode(this.isXSLT() ? "XTDE0410" : "XQTY0024");
                            de.setLocator(components[i]);
                            throw de;
                        }
                        if (foundChild && possibleNodeKinds == 8192 && !maybeEmpty) {
                            de = new XPathException("Cannot create a namespace node after creating a child of the containing element");
                            de.setErrorCode(this.isXSLT() ? "XTDE0410" : "XQTY0024");
                            de.setLocator(components[i]);
                            throw de;
                        }
                        if ((foundChild || foundPossibleChild) && possibleNodeKinds == 4) {
                            env.issueWarning("Creating an attribute here will fail if previous instructions create any children", components[i]);
                        } else if ((foundChild || foundPossibleChild) && possibleNodeKinds == 8192) {
                            env.issueWarning("Creating a namespace node here will fail if previous instructions create any children", components[i]);
                        }
                    }
                }
                ++i;
            }
        }
    }

    public abstract int getNameCode(XPathContext var1) throws XPathException;

    public abstract String getNewBaseURI(XPathContext var1);

    protected abstract void outputNamespaceNodes(XPathContext var1, Receiver var2, int var3) throws XPathException;

    public int[] getActiveNamespaces() throws XPathException {
        return null;
    }

    @Override
    public int getImplementationMethod() {
        return 5;
    }

    @Override
    public EventIterator iterateEvents(XPathContext context) throws XPathException {
        if (!this.preservingTypes && this.validation != 4) {
            return new SingletonEventIterator(this.evaluateItem(context));
        }
        StartElementEvent start = new StartElementEvent(context.getController().makePipelineConfiguration());
        start.setNameCode(this.getNameCode(context));
        start.setTypeCode(this.validation == 3 ? 572 : 630);
        start.setLocalNamespaces(this.getActiveNamespaces());
        start.setLocationId(this.locationId);
        BracketedElementIterator result = new BracketedElementIterator(start, this.content.iterateEvents(context), EndElementEvent.getInstance());
        if (this.validation == 4 && context.getController().getExecutable().isSchemaAware()) {
            return new EventAnnotationStripper(result);
        }
        return result;
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        try {
            SequenceReceiver out;
            int nameCode = this.getNameCode(context);
            int typeCode = this.validation == 3 ? 572 : 630;
            XPathContext c2 = context;
            SequenceReceiver elemOut = out = context.getReceiver();
            if (!this.preservingTypes) {
                Controller controller = context.getController();
                SequenceReceiver validator = controller.getConfiguration().getElementValidator(out, nameCode, this.locationId, this.getSchemaType(), this.validation);
                if (validator != out) {
                    c2 = context.newMinorContext();
                    c2.setOrigin(this);
                    out = new TreeReceiver(validator);
                    c2.setReceiver(out);
                }
                elemOut = out;
            }
            if (elemOut.getSystemId() == null) {
                elemOut.setSystemId(this.getNewBaseURI(c2));
            }
            int properties = this.inheritNamespaces ? 0 : 128;
            elemOut.startElement(nameCode, typeCode, this.locationId, properties);
            this.outputNamespaceNodes(c2, elemOut, nameCode);
            this.content.process(c2);
            elemOut.endElement();
            return null;
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            e.maybeSetContext(context);
            throw e;
        }
    }

    @Override
    public void processLeft(Stack<XPathContext> contextStack, Stack state) throws XPathException {
        XPathContext context = contextStack.peek();
        try {
            int nameCode = this.getNameCode(context);
            int typeCode = this.validation == 3 ? 572 : 630;
            SequenceReceiver out = context.getReceiver();
            state.push(out);
            SequenceReceiver elemOut = out;
            if (!this.preservingTypes) {
                Controller controller = context.getController();
                SequenceReceiver validator = controller.getConfiguration().getElementValidator(out, nameCode, this.locationId, this.getSchemaType(), this.validation);
                if (validator != out) {
                    out = new TreeReceiver(validator);
                    context.setReceiver(out);
                }
                elemOut = out;
            }
            if (elemOut.getSystemId() == null) {
                elemOut.setSystemId(this.getNewBaseURI(context));
            }
            int properties = this.inheritNamespaces ? 0 : 128;
            elemOut.startElement(nameCode, typeCode, this.locationId, properties);
            this.outputNamespaceNodes(context, elemOut, nameCode);
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            e.maybeSetContext(context);
            throw e;
        }
    }

    @Override
    public void processRight(Stack<XPathContext> contextStack, Stack state) throws XPathException {
        XPathContext context = contextStack.peek();
        SequenceReceiver out = (SequenceReceiver)state.pop();
        out.endElement();
        context.setReceiver(out);
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        if (this.isLazyConstruction() && this.preservingTypes) {
            return context.getConfiguration().makeUnconstructedElement(this, context);
        }
        return this.constructElement(context);
    }

    private NodeInfo constructElement(XPathContext context) throws XPathException {
        try {
            Controller controller = context.getController();
            XPathContextMinor c2 = context.newMinorContext();
            c2.setOrigin(this);
            SequenceOutputter seq = controller.allocateSequenceOutputter(1);
            PipelineConfiguration pipe = controller.makePipelineConfiguration();
            pipe.setHostLanguage(this.getHostLanguage());
            seq.setPipelineConfiguration(pipe);
            int nameCode = this.getNameCode(c2);
            int typeCode = this.validation == 3 ? 572 : 630;
            SequenceReceiver ini = seq;
            if (!this.preservingTypes) {
                SequenceReceiver validator = controller.getConfiguration().getElementValidator(ini, nameCode, this.locationId, this.getSchemaType(), this.validation);
                if (ini.getSystemId() == null) {
                    ini.setSystemId(this.getNewBaseURI(c2));
                }
                if (validator == ini) {
                    c2.setTemporaryReceiver(ini);
                } else {
                    TreeReceiver tr = new TreeReceiver(validator);
                    tr.setPipelineConfiguration(seq.getPipelineConfiguration());
                    c2.setReceiver(tr);
                    ini = tr;
                }
            } else {
                c2.setTemporaryReceiver(ini);
                if (ini.getSystemId() == null) {
                    ini.setSystemId(this.getNewBaseURI(c2));
                }
            }
            ini.open();
            int properties = this.inheritNamespaces ? 0 : 128;
            ini.startElement(nameCode, typeCode, this.locationId, properties);
            this.outputNamespaceNodes(c2, ini, nameCode);
            this.content.process(c2);
            ini.endElement();
            ini.close();
            NodeInfo result = (NodeInfo)seq.popLastItem();
            seq.reset();
            return result;
        }
        catch (XPathException err) {
            if (err instanceof ValidationException) {
                ((ValidationException)err).setSourceLocator(this);
                ((ValidationException)err).setSystemId(this.getSystemId());
            }
            err.maybeSetLocation(this);
            err.maybeSetContext(context);
            throw err;
        }
    }
}

