/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.instruct;

import java.util.Stack;
import net2.sf.saxon.Controller;
import net2.sf.saxon.event.Builder;
import net2.sf.saxon.event.PipelineConfiguration;
import net2.sf.saxon.event.SequenceReceiver;
import net2.sf.saxon.evpull.BracketedDocumentIterator;
import net2.sf.saxon.evpull.EventIterator;
import net2.sf.saxon.evpull.SingletonEventIterator;
import net2.sf.saxon.expr.CastExpression;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionTool;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.StaticContext;
import net2.sf.saxon.expr.StringLiteral;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.expr.XPathContextMinor;
import net2.sf.saxon.functions.StringJoin;
import net2.sf.saxon.functions.SystemFunction;
import net2.sf.saxon.instruct.Block;
import net2.sf.saxon.instruct.FixedElement;
import net2.sf.saxon.instruct.ParentNodeConstructor;
import net2.sf.saxon.instruct.TailCall;
import net2.sf.saxon.instruct.ValueOf;
import net2.sf.saxon.om.DocumentInfo;
import net2.sf.saxon.om.FastStringBuffer;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.Validation;
import net2.sf.saxon.pattern.NodeKindTest;
import net2.sf.saxon.pattern.NodeTest;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.SchemaDeclaration;
import net2.sf.saxon.type.SchemaType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.StringValue;
import net2.sf.saxon.value.TextFragmentValue;
import net2.sf.saxon.value.UntypedAtomicValue;

public class DocumentInstr
extends ParentNodeConstructor {
    private boolean textOnly;
    private String constantText;

    public DocumentInstr(boolean textOnly, String constantText, String baseURI) {
        this.textOnly = textOnly;
        this.constantText = constantText;
        this.setBaseURI(baseURI);
    }

    @Override
    public int getImplementationMethod() {
        return 1;
    }

    public boolean isTextOnly() {
        return this.textOnly;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.setLazyConstruction(visitor.getConfiguration().isLazyConstructionMode());
        return super.simplify(visitor);
    }

    @Override
    protected void checkContentSequence(StaticContext env) throws XPathException {
        DocumentInstr.checkContentSequence(env, this.content, this.validation, this.getSchemaType());
    }

    protected static void checkContentSequence(StaticContext env, Expression content, int validation, SchemaType type) throws XPathException {
        Expression[] components = content instanceof Block ? ((Block)content).getChildren() : new Expression[]{content};
        int elementCount = 0;
        boolean isXSLT = content.getHostLanguage() == 50;
        TypeHierarchy th = env.getConfiguration().getTypeHierarchy();
        int i = 0;
        while (i < components.length) {
            ItemType it = components[i].getItemType(th);
            if (it instanceof NodeTest) {
                XPathException de;
                int possibleNodeKinds = ((NodeTest)it).getNodeKindMask();
                if (possibleNodeKinds == 4) {
                    de = new XPathException("Cannot create an attribute node whose parent is a document node");
                    de.setErrorCode(isXSLT ? "XTDE0420" : "XPTY0004");
                    de.setLocator(components[i]);
                    throw de;
                }
                if (possibleNodeKinds == 8192) {
                    de = new XPathException("Cannot create a namespace node whose parent is a document node");
                    de.setErrorCode(isXSLT ? "XTDE0420" : "XQTY0024");
                    de.setLocator(components[i]);
                    throw de;
                }
                if (possibleNodeKinds == 2) {
                    SchemaDeclaration decl;
                    if (++elementCount > 1 && (validation == 1 || validation == 2 || type != null)) {
                        de = new XPathException("A valid document must have only one child element");
                        if (isXSLT) {
                            de.setErrorCode("XTTE1550");
                        } else {
                            de.setErrorCode("XQDY0061");
                        }
                        de.setLocator(components[i]);
                        throw de;
                    }
                    if (validation == 1 && components[i] instanceof FixedElement && (decl = env.getConfiguration().getElementDeclaration(((FixedElement)components[i]).getNameCode(null) & 0xFFFFF)) != null) {
                        ((FixedElement)components[i]).getContentExpression().checkPermittedContents(decl.getType(), env, true);
                    }
                }
            }
            ++i;
        }
    }

    public Expression getStringValueExpression(StaticContext env) {
        if (this.textOnly) {
            if (this.constantText != null) {
                return new StringLiteral(new UntypedAtomicValue(this.constantText));
            }
            if (this.content instanceof ValueOf) {
                return ((ValueOf)this.content).convertToStringJoin(env);
            }
            StringJoin fn = (StringJoin)SystemFunction.makeSystemFunction("string-join", new Expression[]{this.content, new StringLiteral(StringValue.EMPTY_STRING)});
            CastExpression cast = new CastExpression(fn, BuiltInAtomicType.UNTYPED_ATOMIC, false);
            ExpressionTool.copyLocationInfo(this, cast);
            return cast;
        }
        throw new AssertionError((Object)"getStringValueExpression() called on non-text-only document instruction");
    }

    @Override
    public Expression copy() {
        DocumentInstr doc = new DocumentInstr(this.textOnly, this.constantText, this.getBaseURI());
        doc.setContentExpression(this.content.copy());
        doc.setValidationMode(this.getValidationMode());
        doc.setSchemaType(this.getSchemaType());
        doc.setLazyConstruction(this.isLazyConstruction());
        return doc;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return NodeKindTest.DOCUMENT;
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        if (this.validation != 3 || this.getSchemaType() != null) {
            Item item = this.evaluateItem(context);
            if (item != null) {
                SequenceReceiver out = context.getReceiver();
                out.append(item, this.locationId, 2);
            }
            return null;
        }
        SequenceReceiver out = context.getReceiver();
        out.startDocument(0);
        this.content.process(context);
        out.endDocument();
        return null;
    }

    @Override
    public void processLeft(Stack<XPathContext> contextStack, Stack state) throws XPathException {
        contextStack.peek().getReceiver().startDocument(0);
    }

    @Override
    public void processRight(Stack<XPathContext> contextStack, Stack state) throws XPathException {
        contextStack.peek().getReceiver().endDocument();
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        DocumentInfo root;
        if (this.isLazyConstruction() && (!context.getController().getExecutable().isSchemaAware() || this.validation == 3 && this.getSchemaType() == null)) {
            return context.getConfiguration().makeUnconstructedDocument(this, context);
        }
        Controller controller = context.getController();
        if (this.textOnly) {
            CharSequence textValue;
            if (this.constantText != null) {
                textValue = this.constantText;
            } else {
                Item item;
                FastStringBuffer sb = new FastStringBuffer(64);
                SequenceIterator iter = this.content.iterate(context);
                while ((item = iter.next()) != null) {
                    sb.append(item.getStringValueCS());
                }
                textValue = sb.condense();
            }
            root = new TextFragmentValue(textValue, this.getBaseURI());
            root.setConfiguration(controller.getConfiguration());
        } else {
            try {
                XPathContextMinor c2 = context.newMinorContext();
                c2.setOrigin(this);
                Builder builder = controller.makeBuilder();
                builder.setBaseURI(this.getBaseURI());
                builder.setTiming(false);
                PipelineConfiguration pipe = controller.makePipelineConfiguration();
                pipe.setHostLanguage(this.getHostLanguage());
                builder.setPipelineConfiguration(pipe);
                c2.changeOutputDestination(builder, false, this.validation, this.getSchemaType());
                SequenceReceiver out = c2.getReceiver();
                out.open();
                out.startDocument(0);
                this.content.process(c2);
                out.endDocument();
                out.close();
                root = (DocumentInfo)builder.getCurrentRoot();
            }
            catch (XPathException e) {
                e.maybeSetLocation(this);
                e.maybeSetContext(context);
                throw e;
            }
        }
        return root;
    }

    @Override
    public EventIterator iterateEvents(XPathContext context) throws XPathException {
        if (this.validation != 3) {
            return new SingletonEventIterator(this.evaluateItem(context));
        }
        return new BracketedDocumentIterator(this.content.iterateEvents(context));
    }

    @Override
    public int getInstructionNameCode() {
        return 142;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("documentNode");
        out.emitAttribute("validation", Validation.toString(this.validation));
        if (this.getSchemaType() != null) {
            out.emitAttribute("type", this.getSchemaType().getDescription());
        }
        this.content.explain(out);
        out.endElement();
    }
}

