/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.instruct;

import java.util.Stack;
import net2.sf.saxon.Controller;
import net2.sf.saxon.event.NoOpenStartTagException;
import net2.sf.saxon.event.PipelineConfiguration;
import net2.sf.saxon.event.Receiver;
import net2.sf.saxon.event.SequenceOutputter;
import net2.sf.saxon.event.SequenceReceiver;
import net2.sf.saxon.event.TreeReceiver;
import net2.sf.saxon.expr.ContextItemExpression;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.expr.XPathContextMinor;
import net2.sf.saxon.instruct.CopyOf;
import net2.sf.saxon.instruct.ElementCreator;
import net2.sf.saxon.instruct.TailCall;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NamespaceCodeIterator;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.pattern.NodeKindTest;
import net2.sf.saxon.pattern.NodeTest;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.AnyItemType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.SchemaType;
import net2.sf.saxon.type.TypeHierarchy;

public class Copy
extends ElementCreator {
    private boolean copyNamespaces;
    private ItemType contextItemType;

    public Copy(boolean copyNamespaces, boolean inheritNamespaces, SchemaType schemaType, int validation) {
        this.copyNamespaces = copyNamespaces;
        this.inheritNamespaces = inheritNamespaces;
        this.setSchemaType(schemaType);
        this.validation = validation;
        boolean bl = this.preservingTypes = schemaType == null && validation == 3;
        if (copyNamespaces) {
            this.setLazyConstruction(false);
        }
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.preservingTypes |= !visitor.getConfiguration().isLicensedFeature(1);
        return super.simplify(visitor);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        if (contextItemType == null) {
            XPathException err = new XPathException("Context item for xsl:copy is undefined", "XTTE0945");
            err.setLocator(this);
            throw err;
        }
        if (contextItemType instanceof NodeTest) {
            switch (contextItemType.getPrimitiveType()) {
                case 1: {
                    this.contextItemType = NodeKindTest.ELEMENT;
                    break;
                }
                case 2: {
                    this.contextItemType = NodeKindTest.ATTRIBUTE;
                    break;
                }
                case 9: {
                    this.contextItemType = NodeKindTest.DOCUMENT;
                    break;
                }
                default: {
                    this.contextItemType = contextItemType;
                    break;
                }
            }
        } else {
            this.contextItemType = contextItemType;
        }
        return super.typeCheck(visitor, contextItemType);
    }

    @Override
    public Expression copy() {
        Copy copy = new Copy(this.copyNamespaces, this.inheritNamespaces, this.getSchemaType(), this.validation);
        copy.setContentExpression(this.content.copy());
        return copy;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 2;
    }

    @Override
    public int getInstructionNameCode() {
        return 139;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        if (this.contextItemType == null) {
            return AnyItemType.getInstance();
        }
        return this.contextItemType;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression exp = super.optimize(visitor, contextItemType);
        if (exp == this && contextItemType.isAtomicType()) {
            return new ContextItemExpression();
        }
        return exp;
    }

    @Override
    public int getNameCode(XPathContext context) throws XPathException {
        return ((NodeInfo)context.getContextItem()).getNameCode();
    }

    @Override
    public String getNewBaseURI(XPathContext context) {
        return ((NodeInfo)context.getContextItem()).getBaseURI();
    }

    @Override
    protected void outputNamespaceNodes(XPathContext context, Receiver receiver, int nameCode) throws XPathException {
        if (this.copyNamespaces) {
            NodeInfo element = (NodeInfo)context.getContextItem();
            NamespaceCodeIterator.sendNamespaces(element, receiver);
        } else {
            receiver.namespace(context.getNamePool().getNamespaceCode(nameCode), 0);
        }
    }

    @Override
    public int[] getActiveNamespaces() throws XPathException {
        if (this.copyNamespaces) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        SequenceReceiver out = context.getReceiver();
        Item item = context.getContextItem();
        if (item == null) {
            XPathException err = new XPathException("Context item for xsl:copy is undefined", "XTTE0945");
            err.setLocator(this);
            throw err;
        }
        if (!(item instanceof NodeInfo)) {
            out.append(item, this.locationId, 2);
            return null;
        }
        NodeInfo source = (NodeInfo)item;
        switch (source.getNodeKind()) {
            case 1: {
                return super.processLeavingTail(context);
            }
            case 2: {
                try {
                    CopyOf.copyAttribute(source, this.getSchemaType(), this.validation, this, context, false);
                    break;
                }
                catch (NoOpenStartTagException err) {
                    err.setXPathContext(context);
                    throw Copy.dynamicError(this, err, context);
                }
            }
            case 3: {
                out.characters(source.getStringValueCS(), this.locationId, 0);
                break;
            }
            case 7: {
                out.processingInstruction(source.getDisplayName(), source.getStringValueCS(), this.locationId, 0);
                break;
            }
            case 8: {
                out.comment(source.getStringValueCS(), this.locationId, 0);
                break;
            }
            case 13: {
                try {
                    source.copy(out, 0, false, this.locationId);
                    break;
                }
                catch (NoOpenStartTagException err) {
                    XPathException e = new XPathException(err.getMessage());
                    e.setXPathContext(context);
                    e.setErrorCodeQName(err.getErrorCodeQName());
                    throw Copy.dynamicError(this, e, context);
                }
            }
            case 9: {
                Receiver val;
                XPathContext c2 = context;
                if (!this.preservingTypes && (val = controller.getConfiguration().getDocumentValidator(out, source.getBaseURI(), this.validation, 0, this.getSchemaType(), -1)) != out) {
                    TreeReceiver sr = new TreeReceiver(val);
                    ((SequenceReceiver)sr).setPipelineConfiguration(out.getPipelineConfiguration());
                    c2 = c2.newMinorContext();
                    c2.setReceiver(sr);
                    out = sr;
                }
                out.startDocument(0);
                this.content.process(c2);
                out.endDocument();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown node kind " + source.getNodeKind());
            }
        }
        return null;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        XPathContextMinor c2 = context.newMinorContext();
        c2.setOrigin(this);
        SequenceOutputter seq = controller.allocateSequenceOutputter(1);
        PipelineConfiguration pipe = controller.makePipelineConfiguration();
        pipe.setHostLanguage(this.getHostLanguage());
        seq.setPipelineConfiguration(pipe);
        c2.setTemporaryReceiver(seq);
        this.process(c2);
        seq.close();
        Item item = seq.getFirstItem();
        seq.reset();
        return item;
    }

    @Override
    public void processLeft(Stack<XPathContext> contextStack, Stack state) throws XPathException {
        XPathContext context = contextStack.peek();
        NodeInfo node = (NodeInfo)context.getContextItem();
        int nodeKind = node.getNodeKind();
        switch (nodeKind) {
            case 9: {
                Controller controller;
                Receiver val;
                XPathContext c2 = context;
                SequenceReceiver out = context.getReceiver();
                state.push(out);
                if (!this.preservingTypes && (val = (controller = c2.getController()).getConfiguration().getDocumentValidator(out, node.getBaseURI(), this.validation, 0, this.getSchemaType(), -1)) != out) {
                    TreeReceiver sr = new TreeReceiver(val);
                    ((SequenceReceiver)sr).setPipelineConfiguration(out.getPipelineConfiguration());
                    c2 = c2.newMinorContext();
                    c2.setReceiver(sr);
                    out = sr;
                }
                out.startDocument(0);
                break;
            }
            case 1: {
                super.processLeft(contextStack, state);
                break;
            }
            default: {
                this.process(context);
            }
        }
        state.push(nodeKind);
    }

    @Override
    public void processRight(Stack<XPathContext> contextStack, Stack state) throws XPathException {
        XPathContext context = contextStack.peek();
        int nodeKind = (Integer)state.pop();
        switch (nodeKind) {
            case 9: {
                SequenceReceiver out = context.getReceiver();
                out.endDocument();
                out = (SequenceReceiver)state.pop();
                context.setReceiver(out);
                break;
            }
            case 1: {
                super.processRight(contextStack, state);
                break;
            }
        }
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("copy");
        this.content.explain(out);
        out.endElement();
    }
}

