/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.instruct;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.Controller;
import net2.sf.saxon.event.Receiver;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.expr.PromotionOffer;
import net2.sf.saxon.expr.RoleLocator;
import net2.sf.saxon.expr.StaticContext;
import net2.sf.saxon.expr.StringLiteral;
import net2.sf.saxon.expr.TypeChecker;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.instruct.ElementCreator;
import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.om.NamespaceResolver;
import net2.sf.saxon.om.QNameException;
import net2.sf.saxon.om.Validation;
import net2.sf.saxon.pattern.ContentTypeTest;
import net2.sf.saxon.pattern.NodeKindTest;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ComplexType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.SchemaType;
import net2.sf.saxon.type.SimpleType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.type.Untyped;
import net2.sf.saxon.value.AnyURIValue;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.QNameValue;
import net2.sf.saxon.value.SequenceType;
import net2.sf.saxon.value.StringValue;

public class ComputedElement
extends ElementCreator {
    private Expression elementName;
    private Expression namespace = null;
    private NamespaceResolver nsContext;
    private boolean allowNameAsQName;
    private ItemType itemType;

    public ComputedElement(Expression elementName, Expression namespace, NamespaceResolver nsContext, SchemaType schemaType, int validation, boolean inheritNamespaces, boolean allowQName) {
        this.elementName = elementName;
        this.namespace = namespace;
        this.nsContext = nsContext;
        this.setSchemaType(schemaType);
        this.validation = validation;
        this.preservingTypes = schemaType == null && validation == 3;
        this.inheritNamespaces = inheritNamespaces;
        this.allowNameAsQName = allowQName;
        this.adoptChildExpression(elementName);
        this.adoptChildExpression(namespace);
    }

    public Expression getNameExpression() {
        return this.elementName;
    }

    public Expression getNamespaceExpression() {
        return this.namespace;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.nsContext;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.elementName = visitor.simplify(this.elementName);
        this.namespace = visitor.simplify(this.namespace);
        Configuration config = visitor.getConfiguration();
        this.setLazyConstruction(config.isLazyConstructionMode());
        this.preservingTypes |= !config.isLicensedFeature(1);
        if (this.getSchemaType() != null) {
            this.itemType = new ContentTypeTest(1, this.getSchemaType(), config);
            this.getSchemaType().analyzeContentExpression(this.content, 1, visitor.getStaticContext());
        } else {
            this.itemType = this.validation == 4 || !config.isLicensedFeature(1) ? new ContentTypeTest(1, Untyped.getInstance(), config) : NodeKindTest.ELEMENT;
        }
        return super.simplify(visitor);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.elementName = visitor.typeCheck(this.elementName, contextItemType);
        RoleLocator role = new RoleLocator(4, (Serializable)((Object)"element/name"), 0);
        if (this.allowNameAsQName) {
            ItemType supplied;
            this.elementName = TypeChecker.staticTypeCheck(this.elementName, SequenceType.SINGLE_ATOMIC, false, role, visitor);
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            if (th.relationship(supplied = this.elementName.getItemType(th), BuiltInAtomicType.STRING) == 4 && th.relationship(supplied, BuiltInAtomicType.UNTYPED_ATOMIC) == 4 && th.relationship(supplied, BuiltInAtomicType.QNAME) == 4) {
                XPathException de = new XPathException("The name of a constructed element must be a string, QName, or untypedAtomic");
                de.setErrorCode("XPTY0004");
                de.setIsTypeError(true);
                de.setLocator(this);
                throw de;
            }
        } else {
            this.elementName = TypeChecker.staticTypeCheck(this.elementName, SequenceType.SINGLE_STRING, false, role, visitor);
        }
        if (this.namespace != null) {
            this.namespace = visitor.typeCheck(this.namespace, contextItemType);
            role = new RoleLocator(4, (Serializable)((Object)"attribute/namespace"), 0);
            this.namespace = TypeChecker.staticTypeCheck(this.namespace, SequenceType.SINGLE_STRING, false, role, visitor);
        }
        if (Literal.isAtomic(this.elementName)) {
            try {
                AtomicValue val = (AtomicValue)((Literal)this.elementName).getValue();
                if (val instanceof StringValue) {
                    String[] parts = visitor.getConfiguration().getNameChecker().checkQNameParts(val.getStringValueCS());
                    if (this.namespace == null) {
                        String prefix = parts[0];
                        String uri = this.getNamespaceResolver().getURIForPrefix(prefix, true);
                        if (uri == null) {
                            XPathException se = new XPathException("Prefix " + prefix + " has not been declared");
                            se.setErrorCode("XPST0081");
                            se.setIsStaticError(true);
                            throw se;
                        }
                        this.namespace = new StringLiteral(uri);
                    }
                }
            }
            catch (XPathException e) {
                String code = e.getErrorCodeLocalPart();
                if (code == null || code.equals("FORG0001")) {
                    e.setErrorCode(this.isXSLT() ? "XTDE0820" : "XQDY0074");
                } else if (code.equals("XPST0081")) {
                    e.setErrorCode(this.isXSLT() ? "XTDE0830" : "XQDY0074");
                }
                e.maybeSetLocation(this);
                e.setIsStaticError(true);
                throw e;
            }
        }
        return super.typeCheck(visitor, contextItemType);
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.elementName = visitor.optimize(this.elementName, contextItemType);
        return super.optimize(visitor, contextItemType);
    }

    @Override
    public Expression copy() {
        ComputedElement ce = new ComputedElement(this.elementName.copy(), this.namespace == null ? null : this.namespace.copy(), this.getNamespaceResolver(), this.getSchemaType(), this.validation, this.inheritNamespaces, this.allowNameAsQName);
        ce.setContentExpression(this.content.copy());
        return ce;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        if (this.itemType == null) {
            return super.getItemType(th);
        }
        return this.itemType;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        ArrayList<Expression> list = new ArrayList<Expression>(3);
        list.add(this.content);
        list.add(this.elementName);
        if (this.namespace != null) {
            list.add(this.namespace);
        }
        return list.iterator();
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.content == original) {
            this.content = replacement;
            found = true;
        }
        if (this.elementName == original) {
            this.elementName = replacement;
            found = true;
        }
        if (this.namespace == original) {
            this.namespace = replacement;
            found = true;
        }
        return found;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        this.elementName = this.doPromotion(this, this.elementName, offer);
        if (this.namespace != null) {
            this.namespace = this.doPromotion(this, this.namespace, offer);
        }
        super.promoteInst(offer);
    }

    @Override
    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        if (parentType instanceof SimpleType) {
            XPathException err = new XPathException("Elements are not permitted here: the containing element has the simple type " + parentType.getDescription());
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
        if (((ComplexType)parentType).isSimpleContent()) {
            XPathException err = new XPathException("Elements are not permitted here: the containing element has a complex type with simple content");
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
    }

    @Override
    public int getNameCode(XPathContext context) throws XPathException {
        String localName;
        String prefix;
        Controller controller = context.getController();
        NamePool pool = controller.getNamePool();
        String uri = null;
        AtomicValue nameValue = (AtomicValue)this.elementName.evaluateItem(context);
        if (nameValue == null) {
            XPathException err1 = new XPathException("Invalid element name (empty sequence)", this);
            err1.setErrorCode(this.isXSLT() ? "XTDE0820" : "XPTY0004");
            err1.setXPathContext(context);
            throw ComputedElement.dynamicError(this, err1, context);
        }
        if (nameValue instanceof StringValue) {
            CharSequence rawName = nameValue.getStringValueCS();
            try {
                String[] parts = controller.getConfiguration().getNameChecker().getQNameParts(rawName);
                prefix = parts[0];
                localName = parts[1];
            }
            catch (QNameException err) {
                XPathException err1 = new XPathException("Invalid element name. " + err.getMessage(), this);
                err1.setErrorCode(this.isXSLT() ? "XTDE0820" : "XQDY0074");
                err1.setXPathContext(context);
                throw ComputedElement.dynamicError(this, err1, context);
            }
        } else if (nameValue instanceof QNameValue && this.allowNameAsQName) {
            localName = ((QNameValue)nameValue).getLocalName();
            uri = ((QNameValue)nameValue).getNamespaceURI();
            if (uri == null) {
                uri = "";
            }
            prefix = ((QNameValue)nameValue).getPrefix();
        } else {
            XPathException err = new XPathException("Computed element name has incorrect type");
            err.setErrorCode(this.isXSLT() ? "XTDE0820" : "XPTY0004");
            err.setIsTypeError(true);
            err.setXPathContext(context);
            throw ComputedElement.dynamicError(this, err, context);
        }
        if (this.namespace == null && uri == null) {
            uri = this.nsContext.getURIForPrefix(prefix, true);
            if (uri == null) {
                XPathException err = new XPathException("Undeclared prefix in element name: " + prefix, this);
                err.setErrorCode(this.isXSLT() ? "XTDE0830" : "XQDY0074");
                err.setXPathContext(context);
                throw ComputedElement.dynamicError(this, err, context);
            }
        } else {
            if (uri == null) {
                if (this.namespace instanceof StringLiteral) {
                    uri = ((StringLiteral)this.namespace).getStringValue();
                } else {
                    uri = this.namespace.evaluateAsString(context).toString();
                    if (!AnyURIValue.isValidURI(uri)) {
                        XPathException de = new XPathException("The value of the namespace attribute must be a valid URI");
                        de.setErrorCode("XTDE0835");
                        de.setXPathContext(context);
                        de.setLocator(this);
                        throw de;
                    }
                }
            }
            if (uri.length() == 0) {
                prefix = "";
            }
            if (prefix.equals("xmlns")) {
                prefix = "x-xmlns";
            }
        }
        return pool.allocate(prefix, uri, localName);
    }

    @Override
    public String getNewBaseURI(XPathContext context) {
        return this.getBaseURI();
    }

    @Override
    protected void outputNamespaceNodes(XPathContext context, Receiver out, int nameCode) throws XPathException {
    }

    @Override
    public int getInstructionNameCode() {
        return 143;
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("computedElement");
        out.emitAttribute("validation", Validation.toString(this.validation));
        if (this.getSchemaType() != null) {
            out.emitAttribute("type", this.getSchemaType().getDescription());
        }
        out.startSubsidiaryElement("name");
        this.elementName.explain(out);
        out.endSubsidiaryElement();
        if (this.namespace != null) {
            out.startSubsidiaryElement("namespace");
            this.namespace.explain(out);
            out.endSubsidiaryElement();
        }
        out.startSubsidiaryElement("content");
        this.content.explain(out);
        out.endSubsidiaryElement();
        out.endElement();
    }
}

