/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.instruct;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import net2.sf.saxon.Controller;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.PromotionOffer;
import net2.sf.saxon.expr.RoleLocator;
import net2.sf.saxon.expr.TypeChecker;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.expr.XPathContextMajor;
import net2.sf.saxon.instruct.Instruction;
import net2.sf.saxon.instruct.LocalParam;
import net2.sf.saxon.instruct.ParameterSet;
import net2.sf.saxon.instruct.TailCall;
import net2.sf.saxon.instruct.Template;
import net2.sf.saxon.instruct.WithParam;
import net2.sf.saxon.om.NamespaceResolver;
import net2.sf.saxon.om.QNameException;
import net2.sf.saxon.om.StructuredQName;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.AnyItemType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.SequenceType;

public class CallTemplate
extends Instruction {
    private Template template = null;
    private WithParam[] actualParams = null;
    private WithParam[] tunnelParams = null;
    private boolean useTailRecursion = false;
    private Expression calledTemplateExpression;
    private NamespaceResolver nsContext;

    public CallTemplate(Template template, boolean useTailRecursion, Expression calledTemplateExpression, NamespaceResolver nsContext) {
        this.template = template;
        this.useTailRecursion = useTailRecursion;
        this.calledTemplateExpression = calledTemplateExpression;
        this.nsContext = nsContext;
        this.adoptChildExpression(calledTemplateExpression);
    }

    public void setActualParameters(WithParam[] actualParams, WithParam[] tunnelParams) {
        this.actualParams = actualParams;
        this.tunnelParams = tunnelParams;
        int i = 0;
        while (i < actualParams.length) {
            this.adoptChildExpression(actualParams[i]);
            ++i;
        }
        i = 0;
        while (i < tunnelParams.length) {
            this.adoptChildExpression(tunnelParams[i]);
            ++i;
        }
    }

    @Override
    public int getInstructionNameCode() {
        return 133;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        WithParam.simplify(this.actualParams, visitor);
        WithParam.simplify(this.tunnelParams, visitor);
        if (this.calledTemplateExpression != null) {
            this.calledTemplateExpression = visitor.simplify(this.calledTemplateExpression);
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        WithParam.typeCheck(this.actualParams, visitor, contextItemType);
        WithParam.typeCheck(this.tunnelParams, visitor, contextItemType);
        if (this.calledTemplateExpression != null) {
            this.calledTemplateExpression = visitor.typeCheck(this.calledTemplateExpression, contextItemType);
            this.adoptChildExpression(this.calledTemplateExpression);
        } else if (this.template.getBody() != null) {
            boolean backwards = visitor.getStaticContext().isInBackwardsCompatibleMode();
            int p = 0;
            while (p < this.actualParams.length) {
                WithParam wp = this.actualParams[p];
                int id = wp.getParameterId();
                LocalParam lp = this.template.getLocalParam(id);
                if (lp != null) {
                    SequenceType req = lp.getRequiredType();
                    RoleLocator role = new RoleLocator(8, (Serializable)((Object)wp.getVariableQName().getDisplayName()), p);
                    Expression select = TypeChecker.staticTypeCheck(wp.getSelectExpression(), req, backwards, role, visitor);
                    wp.setSelectExpression(select);
                    wp.setTypeChecked(true);
                }
                ++p;
            }
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        WithParam.optimize(visitor, this.actualParams, contextItemType);
        WithParam.optimize(visitor, this.tunnelParams, contextItemType);
        if (this.calledTemplateExpression != null) {
            this.calledTemplateExpression = visitor.optimize(this.calledTemplateExpression, contextItemType);
            this.adoptChildExpression(this.calledTemplateExpression);
        }
        return this;
    }

    @Override
    public int computeCardinality() {
        if (this.template == null) {
            return 57344;
        }
        return this.template.getRequiredType().getCardinality();
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        if (this.template == null) {
            return AnyItemType.getInstance();
        }
        return this.template.getRequiredType().getPrimaryType();
    }

    @Override
    public Expression copy() {
        throw new UnsupportedOperationException("copy");
    }

    @Override
    public int getIntrinsicDependencies() {
        return 639;
    }

    @Override
    public final boolean createsNewNodes() {
        return true;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        ArrayList<Expression> list = new ArrayList<Expression>(10);
        if (this.calledTemplateExpression != null) {
            list.add(this.calledTemplateExpression);
        }
        WithParam.getXPathExpressions(this.actualParams, list);
        WithParam.getXPathExpressions(this.tunnelParams, list);
        return list.iterator();
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (WithParam.replaceXPathExpression(this.actualParams, original, replacement)) {
            found = true;
        }
        if (WithParam.replaceXPathExpression(this.tunnelParams, original, replacement)) {
            found = true;
        }
        if (this.calledTemplateExpression == original) {
            this.calledTemplateExpression = replacement;
        }
        return found;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        if (this.calledTemplateExpression != null) {
            this.calledTemplateExpression = this.doPromotion(this, this.calledTemplateExpression, offer);
        }
        WithParam.promoteParams(this, this.actualParams, offer);
        WithParam.promoteParams(this, this.tunnelParams, offer);
    }

    @Override
    public void process(XPathContext context) throws XPathException {
        Template t = this.getTargetTemplate(context);
        XPathContextMajor c2 = context.newContext();
        c2.setOrigin(this);
        c2.openStackFrame(t.getStackFrameMap());
        c2.setLocalParameters(CallTemplate.assembleParams(context, this.actualParams));
        c2.setTunnelParameters(CallTemplate.assembleTunnelParams(context, this.tunnelParams));
        try {
            TailCall tc = t.expand(c2);
            while (tc != null) {
                tc = tc.processLeavingTail();
            }
        }
        catch (StackOverflowError e) {
            XPathException err = new XPathException("Too many nested template or function calls. The stylesheet may be looping.");
            err.setLocator(this);
            err.setXPathContext(context);
            throw err;
        }
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        if (!this.useTailRecursion) {
            this.process(context);
            return null;
        }
        Template target = this.getTargetTemplate(context);
        ParameterSet params = CallTemplate.assembleParams(context, this.actualParams);
        ParameterSet tunnels = CallTemplate.assembleTunnelParams(context, this.tunnelParams);
        if (params == null) {
            params = ParameterSet.EMPTY_PARAMETER_SET;
        }
        Arrays.fill(context.getStackFrame().getStackFrameValues(), null);
        return new CallTemplatePackage(target, params, tunnels, this, context);
    }

    public Template getTargetTemplate(XPathContext context) throws XPathException {
        if (this.calledTemplateExpression != null) {
            String localName;
            String prefix;
            Controller controller = context.getController();
            CharSequence qname = this.calledTemplateExpression.evaluateAsString(context);
            try {
                String[] parts = controller.getConfiguration().getNameChecker().getQNameParts(qname);
                prefix = parts[0];
                localName = parts[1];
            }
            catch (QNameException err) {
                this.dynamicError("Invalid template name. " + err.getMessage(), "XTSE0650", context);
                return null;
            }
            String uri = this.nsContext.getURIForPrefix(prefix, false);
            if (uri == null) {
                this.dynamicError("Namespace prefix " + prefix + " has not been declared", "XTSE0650", context);
            }
            StructuredQName qName = new StructuredQName("", uri, localName);
            Template target = controller.getExecutable().getNamedTemplate(qName);
            if (target == null) {
                this.dynamicError("Template " + qname + " has not been defined", "XTSE0650", context);
            }
            return target;
        }
        return this.template;
    }

    @Override
    public StructuredQName getObjectName() {
        return this.template == null ? null : this.template.getTemplateName();
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("callTemplate");
        if (this.template != null) {
            out.emitAttribute("name", this.template.getTemplateName() == null ? "null" : this.template.getTemplateName().getDisplayName());
        } else {
            out.startSubsidiaryElement("name");
            this.calledTemplateExpression.explain(out);
            out.endSubsidiaryElement();
        }
        if (this.actualParams != null && this.actualParams.length > 0) {
            out.startSubsidiaryElement("withParams");
            WithParam.displayExpressions(this.actualParams, out);
            out.endSubsidiaryElement();
        }
        if (this.tunnelParams != null && this.tunnelParams.length > 0) {
            out.startSubsidiaryElement("tunnelParams");
            WithParam.displayExpressions(this.tunnelParams, out);
            out.endSubsidiaryElement();
        }
        out.endElement();
    }

    public static class CallTemplatePackage
    implements TailCall {
        private Template target;
        private ParameterSet params;
        private ParameterSet tunnelParams;
        private Instruction instruction;
        private XPathContext evaluationContext;

        public CallTemplatePackage(Template template, ParameterSet params, ParameterSet tunnelParams, Instruction instruction, XPathContext evaluationContext) {
            this.target = template;
            this.params = params;
            this.tunnelParams = tunnelParams;
            this.instruction = instruction;
            this.evaluationContext = evaluationContext;
        }

        @Override
        public TailCall processLeavingTail() throws XPathException {
            XPathContextMajor c2 = this.evaluationContext.newContext();
            c2.setOrigin(this.instruction);
            c2.setLocalParameters(this.params);
            c2.setTunnelParameters(this.tunnelParams);
            c2.openStackFrame(this.target.getStackFrameMap());
            return this.target.expand(c2);
        }
    }
}

