/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.instruct;

import net2.sf.saxon.event.SequenceReceiver;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.instruct.DummyNamespaceResolver;
import net2.sf.saxon.instruct.SimpleNodeConstructor;
import net2.sf.saxon.trans.Err;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.SimpleType;
import net2.sf.saxon.type.UnresolvedReferenceException;
import net2.sf.saxon.type.ValidationException;
import net2.sf.saxon.type.ValidationFailure;
import net2.sf.saxon.value.Whitespace;

public abstract class AttributeCreator
extends SimpleNodeConstructor {
    private SimpleType schemaType;
    private int annotation;
    private int validationAction;
    private int options;

    public void setSchemaType(SimpleType type) {
        this.schemaType = type;
    }

    public SimpleType getSchemaType() {
        return this.schemaType;
    }

    public void setValidationAction(int action) {
        this.validationAction = action;
    }

    public int getValidationAction() {
        return this.validationAction;
    }

    public void setOptions(int options) {
        this.options = options;
    }

    public void setRejectDuplicates() {
        this.options |= 0x20;
    }

    public void setNoSpecialChars() {
        this.options |= 4;
    }

    public int getOptions() {
        return this.options;
    }

    public void setAnnotation(int type) {
        this.annotation = type;
    }

    public int getAnnotation() {
        return this.annotation;
    }

    @Override
    protected final void processValue(CharSequence value, XPathContext context) throws XPathException {
        int ann;
        int opt;
        SequenceReceiver out;
        int nameCode;
        block10: {
            nameCode = this.evaluateNameCode(context);
            out = context.getReceiver();
            opt = this.getOptions();
            ann = this.getAnnotation();
            SimpleType schemaType = this.getSchemaType();
            int validationAction = this.getValidationAction();
            if (schemaType != null) {
                try {
                    ValidationFailure err = schemaType.validateContent(value, DummyNamespaceResolver.getInstance(), context.getConfiguration().getNameChecker());
                    if (err != null) {
                        ValidationException ve = new ValidationException("Attribute value " + Err.wrap(value, 4) + " does not match the required type " + schemaType.getDescription() + ". " + err.getMessage());
                        ve.setErrorCode("XTTE1540");
                        throw ve;
                    }
                    break block10;
                }
                catch (UnresolvedReferenceException ure) {
                    throw new ValidationException(ure);
                }
            }
            if (validationAction == 1 || validationAction == 2) {
                try {
                    ann = context.getConfiguration().validateAttribute(nameCode, value, validationAction);
                }
                catch (ValidationException e) {
                    XPathException err = XPathException.makeXPathException(e);
                    err.maybeSetErrorCode(validationAction == 1 ? "XTTE1510" : "XTTE1515");
                    err.setXPathContext(context);
                    err.maybeSetLocation(this);
                    err.setIsTypeError(true);
                    throw err;
                }
            }
        }
        if ((nameCode & 0xFFFFF) == 388) {
            value = Whitespace.collapseWhitespace(value);
        }
        try {
            out.attribute(nameCode, ann, value, this.locationId, opt);
        }
        catch (XPathException err) {
            throw AttributeCreator.dynamicError(this, err, context);
        }
    }
}

