/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.instruct;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.Platform;
import net2.sf.saxon.expr.ContextMappingFunction;
import net2.sf.saxon.expr.ContextMappingIterator;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.PromotionOffer;
import net2.sf.saxon.expr.RoleLocator;
import net2.sf.saxon.expr.StaticContext;
import net2.sf.saxon.expr.StringLiteral;
import net2.sf.saxon.expr.TypeChecker;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.expr.XPathContextMajor;
import net2.sf.saxon.instruct.Instruction;
import net2.sf.saxon.instruct.TailCall;
import net2.sf.saxon.om.EmptyIterator;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.pattern.EmptySequenceTest;
import net2.sf.saxon.regex.JRegularExpression;
import net2.sf.saxon.regex.RegexIterator;
import net2.sf.saxon.regex.RegularExpression;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.SchemaType;
import net2.sf.saxon.type.Type;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.SequenceType;

public class AnalyzeString
extends Instruction {
    private Expression select;
    private Expression regex;
    private Expression flags;
    private Expression matching;
    private Expression nonMatching;
    private RegularExpression pattern;

    public AnalyzeString(Expression select, Expression regex, Expression flags, Expression matching, Expression nonMatching, RegularExpression pattern) {
        this.select = select;
        this.regex = regex;
        this.flags = flags;
        this.matching = matching;
        this.nonMatching = nonMatching;
        this.pattern = pattern;
        Iterator<Expression> kids = this.iterateSubExpressions();
        while (kids.hasNext()) {
            Expression child = kids.next();
            this.adoptChildExpression(child);
        }
    }

    @Override
    public int getInstructionNameCode() {
        return 128;
    }

    @Override
    public int getImplementationMethod() {
        return 6;
    }

    public Expression getMatchingExpression() {
        return this.matching;
    }

    public Expression getNonMatchingExpression() {
        return this.nonMatching;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.select = visitor.simplify(this.select);
        this.regex = visitor.simplify(this.regex);
        this.flags = visitor.simplify(this.flags);
        this.matching = visitor.simplify(this.matching);
        this.nonMatching = visitor.simplify(this.nonMatching);
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.select = visitor.typeCheck(this.select, contextItemType);
        this.adoptChildExpression(this.select);
        this.regex = visitor.typeCheck(this.regex, contextItemType);
        this.adoptChildExpression(this.regex);
        this.flags = visitor.typeCheck(this.flags, contextItemType);
        this.adoptChildExpression(this.flags);
        if (this.matching != null) {
            this.matching = visitor.typeCheck(this.matching, BuiltInAtomicType.STRING);
            this.adoptChildExpression(this.matching);
        }
        if (this.nonMatching != null) {
            this.nonMatching = visitor.typeCheck(this.nonMatching, BuiltInAtomicType.STRING);
            this.adoptChildExpression(this.nonMatching);
        }
        RoleLocator role = new RoleLocator(4, (Serializable)((Object)"analyze-string/select"), 0);
        this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.SINGLE_STRING, false, role, visitor);
        role = new RoleLocator(4, (Serializable)((Object)"analyze-string/regex"), 0);
        this.regex = TypeChecker.staticTypeCheck(this.regex, SequenceType.SINGLE_STRING, false, role, visitor);
        role = new RoleLocator(4, (Serializable)((Object)"analyze-string/flags"), 0);
        this.flags = TypeChecker.staticTypeCheck(this.flags, SequenceType.SINGLE_STRING, false, role, visitor);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.select = visitor.optimize(this.select, contextItemType);
        this.adoptChildExpression(this.select);
        this.regex = visitor.optimize(this.regex, contextItemType);
        this.adoptChildExpression(this.regex);
        this.flags = visitor.optimize(this.flags, contextItemType);
        this.adoptChildExpression(this.flags);
        if (this.matching != null) {
            this.matching = this.matching.optimize(visitor, BuiltInAtomicType.STRING);
            this.adoptChildExpression(this.matching);
        }
        if (this.nonMatching != null) {
            this.nonMatching = this.nonMatching.optimize(visitor, BuiltInAtomicType.STRING);
            this.adoptChildExpression(this.nonMatching);
        }
        if (this.pattern == null && this.regex instanceof StringLiteral && this.flags instanceof StringLiteral) {
            try {
                Platform platform = Configuration.getPlatform();
                String regex = ((StringLiteral)this.regex).getStringValue();
                String flagstr = ((StringLiteral)this.flags).getStringValue();
                int xmlVersion = visitor.getConfiguration().getXMLVersion();
                int flagBits = JRegularExpression.setFlags(flagstr);
                this.pattern = new JRegularExpression(regex, xmlVersion, 0, flagBits);
                if (this.pattern.matches("")) {
                    this.pattern = new JRegularExpression("x", xmlVersion, 0, flagBits);
                    this.invalidRegex("The regular expression must not be one that matches a zero-length string", "XTDE1150");
                }
            }
            catch (XPathException err) {
                if ("XTDE1150".equals(err.getErrorCodeLocalPart())) {
                    throw err;
                }
                if ("FORX0001".equals(err.getErrorCodeLocalPart())) {
                    this.invalidRegex("Error in regular expression flags: " + err, "XTDE1145");
                }
                this.invalidRegex("Error in regular expression: " + err, "XTDE1140");
            }
        }
        return this;
    }

    private void invalidRegex(String message, String errorCode) throws XPathException {
        this.pattern = null;
        XPathException err = new XPathException(message, errorCode);
        err.setLocator(this);
        throw err;
    }

    @Override
    public Expression copy() {
        throw new UnsupportedOperationException("copy");
    }

    @Override
    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        if (this.matching != null) {
            this.matching.checkPermittedContents(parentType, env, false);
        }
        if (this.nonMatching != null) {
            this.nonMatching.checkPermittedContents(parentType, env, false);
        }
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        if (this.matching != null) {
            if (this.nonMatching != null) {
                return Type.getCommonSuperType(this.matching.getItemType(th), this.nonMatching.getItemType(th), th);
            }
            return this.matching.getItemType(th);
        }
        if (this.nonMatching != null) {
            return this.nonMatching.getItemType(th);
        }
        return EmptySequenceTest.getInstance();
    }

    @Override
    public int computeDependencies() {
        int dependencies = 0;
        dependencies |= this.select.getDependencies();
        dependencies |= this.regex.getDependencies();
        dependencies |= this.flags.getDependencies();
        if (this.matching != null) {
            dependencies |= this.matching.getDependencies() & 0xFFFFFFA1;
        }
        if (this.nonMatching != null) {
            dependencies |= this.nonMatching.getDependencies() & 0xFFFFFFA1;
        }
        return dependencies;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        this.select = this.doPromotion(this, this.select, offer);
        this.regex = this.doPromotion(this, this.regex, offer);
        this.flags = this.doPromotion(this, this.flags, offer);
        if (this.matching != null) {
            this.matching = this.doPromotion(this, this.matching, offer);
        }
        if (this.nonMatching != null) {
            this.nonMatching = this.doPromotion(this, this.nonMatching, offer);
        }
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        ArrayList<Expression> list = new ArrayList<Expression>(5);
        list.add(this.select);
        list.add(this.regex);
        list.add(this.flags);
        if (this.matching != null) {
            list.add(this.matching);
        }
        if (this.nonMatching != null) {
            list.add(this.nonMatching);
        }
        return list.iterator();
    }

    @Override
    public Iterator<Expression> iterateSameFocusSubExpressions() {
        ArrayList<Expression> list = new ArrayList<Expression>(5);
        list.add(this.select);
        list.add(this.regex);
        list.add(this.flags);
        return list.iterator();
    }

    @Override
    public boolean hasLoopingSubexpression(Expression child) {
        return child == this.matching || child == this.nonMatching;
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.select == original) {
            this.select = replacement;
            found = true;
        }
        if (this.regex == original) {
            this.regex = replacement;
            found = true;
        }
        if (this.flags == original) {
            this.flags = replacement;
            found = true;
        }
        if (this.matching == original) {
            this.matching = replacement;
            found = true;
        }
        if (this.nonMatching == original) {
            this.nonMatching = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Item it;
        RegexIterator iter = this.getRegexIterator(context);
        XPathContextMajor c2 = context.newContext();
        c2.setOrigin(this);
        c2.setCurrentIterator(iter);
        c2.setCurrentRegexIterator(iter);
        while ((it = iter.next()) != null) {
            if (iter.isMatching()) {
                if (this.matching == null) continue;
                this.matching.process(c2);
                continue;
            }
            if (this.nonMatching == null) continue;
            this.nonMatching.process(c2);
        }
        return null;
    }

    private RegexIterator getRegexIterator(XPathContext context) throws XPathException {
        CharSequence input = this.select.evaluateAsString(context);
        RegularExpression re = this.pattern;
        if (re == null) {
            CharSequence flagstr = this.flags.evaluateAsString(context);
            Platform platform = Configuration.getPlatform();
            int xmlVersion = context.getConfiguration().getXMLVersion();
            int flagBits = JRegularExpression.setFlags(flagstr);
            re = new JRegularExpression(this.regex.evaluateAsString(context), xmlVersion, 0, flagBits);
            if (re.matches("")) {
                this.dynamicError("The regular expression must not be one that matches a zero-length string", "XTDE1150", context);
            }
        }
        return re.analyze(input);
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        RegexIterator iter = this.getRegexIterator(context);
        XPathContextMajor c2 = context.newContext();
        c2.setOrigin(this);
        c2.setCurrentIterator(iter);
        c2.setCurrentRegexIterator(iter);
        AnalyzeMappingFunction fn = new AnalyzeMappingFunction(iter, c2);
        return new ContextMappingIterator(fn, c2);
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("analyzeString");
        out.startSubsidiaryElement("select");
        this.select.explain(out);
        out.endSubsidiaryElement();
        out.startSubsidiaryElement("regex");
        this.regex.explain(out);
        out.endSubsidiaryElement();
        out.startSubsidiaryElement("flags");
        this.flags.explain(out);
        out.endSubsidiaryElement();
        if (this.matching != null) {
            out.startSubsidiaryElement("matching");
            this.matching.explain(out);
            out.endSubsidiaryElement();
        }
        if (this.nonMatching != null) {
            out.startSubsidiaryElement("nonMatching");
            this.nonMatching.explain(out);
            out.endSubsidiaryElement();
        }
        out.endElement();
    }

    private class AnalyzeMappingFunction
    implements ContextMappingFunction {
        private RegexIterator base;
        private XPathContext c2;

        public AnalyzeMappingFunction(RegexIterator base, XPathContext c2) {
            this.base = base;
            this.c2 = c2;
        }

        @Override
        public SequenceIterator map(XPathContext context) throws XPathException {
            if (this.base.isMatching()) {
                if (AnalyzeString.this.matching != null) {
                    return AnalyzeString.this.matching.iterate(this.c2);
                }
            } else if (AnalyzeString.this.nonMatching != null) {
                return AnalyzeString.this.nonMatching.iterate(this.c2);
            }
            return EmptyIterator.getInstance();
        }
    }
}

