/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.functions;

import java.io.PrintStream;
import net2.sf.saxon.Controller;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionTool;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.functions.SystemFunction;
import net2.sf.saxon.instruct.InstructionDetails;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NamespaceResolver;
import net2.sf.saxon.om.Navigator;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.trace.TraceListener;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.Type;
import net2.sf.saxon.value.Value;

public class Trace
extends SystemFunction {
    NamespaceResolver resolver;

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.resolver = visitor.getStaticContext().getNamespaceResolver();
        return super.simplify(visitor);
    }

    @Override
    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    @Override
    public int computeSpecialProperties() {
        return this.argument[0].getSpecialProperties();
    }

    @Override
    public int computeCardinality() {
        return this.argument[0].getCardinality();
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        Item val = this.argument[0].evaluateItem(context);
        String label = this.argument[1].evaluateAsString(context).toString();
        Controller controller = context.getController();
        if (controller.isTracing()) {
            this.notifyListener(label, Value.asValue(val), context);
        } else {
            PrintStream out = controller.getTraceFunctionDestination();
            if (out != null) {
                this.traceItem(val, label, out);
            }
        }
        return val;
    }

    private void notifyListener(String label, Value val, XPathContext context) {
        InstructionDetails info = new InstructionDetails();
        info.setConstructType(2031);
        info.setLineNumber(this.getLineNumber());
        info.setSystemId(this.getSystemId());
        info.setProperty("label", label);
        info.setProperty("value", val);
        TraceListener listener = context.getController().getTraceListener();
        listener.enter(info, context);
        listener.leave(info);
    }

    private void traceItem(Item val, String label, PrintStream out) {
        if (val == null) {
            out.println(String.valueOf(label) + ": empty sequence");
        } else if (val instanceof NodeInfo) {
            out.println(String.valueOf(label) + ": " + Type.displayTypeName(val) + ": " + Navigator.getPath((NodeInfo)val));
        } else {
            out.println(String.valueOf(label) + ": " + Type.displayTypeName(val) + ": " + val.getStringValue());
        }
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        if (controller.isTracing()) {
            String label = this.argument[1].evaluateAsString(context).toString();
            Value value = Value.asValue(ExpressionTool.eagerEvaluate(this.argument[0], context));
            this.notifyListener(label, value, context);
            return value.iterate();
        }
        PrintStream out = controller.getTraceFunctionDestination();
        if (out == null) {
            return this.argument[0].iterate(context);
        }
        return new TracingIterator(this.argument[0].iterate(context), this.argument[1].evaluateAsString(context).toString(), out);
    }

    private class TracingIterator
    implements SequenceIterator {
        SequenceIterator base;
        String label;
        PrintStream out;
        boolean empty = true;

        public TracingIterator(SequenceIterator base, String label, PrintStream out) {
            this.base = base;
            this.label = label;
            this.out = out;
        }

        @Override
        public Item next() throws XPathException {
            Item n = this.base.next();
            if (n == null) {
                if (this.empty) {
                    Trace.this.traceItem(null, this.label, this.out);
                }
            } else {
                Trace.this.traceItem(n, String.valueOf(this.label) + " [" + this.position() + ']', this.out);
                this.empty = false;
            }
            return n;
        }

        @Override
        public Item current() {
            return this.base.current();
        }

        @Override
        public int position() {
            return this.base.position();
        }

        @Override
        public void close() {
            this.base.close();
        }

        @Override
        public SequenceIterator getAnother() throws XPathException {
            return new TracingIterator(this.base.getAnother(), this.label, this.out);
        }

        @Override
        public int getProperties() {
            return 0;
        }
    }
}

