/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.functions;

import net2.sf.saxon.expr.ArithmeticExpression;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.functions.NumberFn;
import net2.sf.saxon.functions.SystemFunction;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.Int64Value;
import net2.sf.saxon.value.NumericValue;
import net2.sf.saxon.value.StringValue;

public class Substring
extends SystemFunction {
    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression a2;
        Expression a1;
        Expression e2 = super.typeCheck(visitor, contextItemType);
        if (e2 != this) {
            return e2;
        }
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (this.argument[1] instanceof NumberFn && th.isSubType((a1 = ((NumberFn)this.argument[1]).getArguments()[0]).getItemType(th), BuiltInAtomicType.INTEGER)) {
            this.argument[1] = a1;
        }
        if (this.argument.length > 2 && this.argument[2] instanceof NumberFn && th.isSubType((a2 = ((NumberFn)this.argument[2]).getArguments()[0]).getItemType(th), BuiltInAtomicType.INTEGER)) {
            this.argument[2] = a2;
        }
        return this;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        AtomicValue av = (AtomicValue)this.argument[0].evaluateItem(context);
        if (av == null) {
            return StringValue.EMPTY_STRING;
        }
        StringValue sv = (StringValue)av;
        if (sv.isZeroLength()) {
            return StringValue.EMPTY_STRING;
        }
        AtomicValue a1 = (AtomicValue)this.argument[1].evaluateItem(context);
        NumericValue a = (NumericValue)a1;
        if (this.argument.length == 2) {
            StringValue result = StringValue.makeStringValue(Substring.substring(sv, a));
            if (sv.isKnownToContainNoSurrogates()) {
                result.setContainsNoSurrogates();
            }
            return result;
        }
        AtomicValue b2 = (AtomicValue)this.argument[2].evaluateItem(context);
        NumericValue b = (NumericValue)b2;
        StringValue result = StringValue.makeStringValue(Substring.substring(sv, a, b, context));
        if (sv.isKnownToContainNoSurrogates()) {
            result.setContainsNoSurrogates();
        }
        return result;
    }

    public static CharSequence substring(StringValue sv, NumericValue start) {
        long lstart;
        CharSequence s = sv.getStringValueCS();
        int slength = s.length();
        if (start instanceof Int64Value) {
            lstart = ((Int64Value)start).longValue();
            if (lstart > (long)slength) {
                return "";
            }
            if (lstart <= 0L) {
                lstart = 1L;
            }
        } else {
            if (start.isNaN()) {
                return "";
            }
            if (start.signum() <= 0.0) {
                return s;
            }
            if (start.compareTo(slength) > 0) {
                return "";
            }
            lstart = Math.round(start.getDoubleValue());
        }
        if (!sv.containsSurrogatePairs()) {
            return s.subSequence((int)lstart - 1, s.length());
        }
        int pos = 1;
        int cpos = 0;
        while (cpos < slength) {
            char ch;
            if ((long)pos >= lstart) {
                return s.subSequence(cpos, s.length());
            }
            if ((ch = s.charAt(cpos++)) >= '\ud800' && ch <= '\udbff') continue;
            ++pos;
        }
        return "";
    }

    public static CharSequence substring(StringValue sv, NumericValue start, NumericValue len, XPathContext context) {
        long lend;
        NumericValue end;
        long lstart;
        CharSequence s = sv.getStringValueCS();
        int slength = s.length();
        if (start instanceof Int64Value) {
            lstart = ((Int64Value)start).longValue();
            if (lstart > (long)slength) {
                return "";
            }
        } else {
            if ((start = start.round()).isNaN()) {
                return "";
            }
            if (start.signum() <= 0.0) {
                lstart = 0L;
            } else {
                if (start.compareTo(slength) > 0) {
                    return "";
                }
                try {
                    lstart = start.longValue();
                }
                catch (XPathException err) {
                    throw new AssertionError((Object)"string length out of permissible range");
                }
            }
        }
        try {
            end = (NumericValue)ArithmeticExpression.compute(start, 0, len.round(), context);
        }
        catch (XPathException e) {
            throw new AssertionError((Object)"Unexpected arithmetic failure in substring");
        }
        if (end instanceof Int64Value) {
            lend = ((Int64Value)end).longValue();
        } else {
            if (end.isNaN()) {
                return "";
            }
            if (end.signum() <= 0.0) {
                return "";
            }
            if (end.compareTo(slength) > 0) {
                lend = slength + 1;
            } else {
                try {
                    lend = end.ceiling().longValue();
                }
                catch (XPathException err) {
                    throw new AssertionError((Object)"string length out of permissible range");
                }
            }
        }
        if (lend < lstart) {
            return "";
        }
        if (!sv.containsSurrogatePairs()) {
            return s.subSequence(Math.max((int)lstart - 1, 0), Math.min(slength, (int)lend - 1));
        }
        int jstart = -1;
        int jend = -1;
        int pos = 1;
        int cpos = 0;
        while (cpos < slength) {
            char ch;
            if ((long)pos >= lstart) {
                if ((long)pos < lend) {
                    if (jstart < 0) {
                        jstart = cpos;
                    }
                } else {
                    jend = cpos;
                    break;
                }
            }
            if ((ch = s.charAt(cpos++)) >= '\ud800' && ch <= '\udbff') continue;
            ++pos;
        }
        if (jstart < 0 || jstart == jend) {
            return "";
        }
        if (jend < 0) {
            return s.subSequence(jstart, s.length());
        }
        return s.subSequence(jstart, jend);
    }
}

