/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.functions;

import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.functions.SystemFunction;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.Int64Value;
import net2.sf.saxon.value.StringValue;
import net2.sf.saxon.value.Value;

public class StringLength
extends SystemFunction {
    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        return this.simplifyArguments(visitor);
    }

    @Override
    public int getIntrinsicDependencies() {
        int d = super.getIntrinsicDependencies();
        if (this.argument.length == 0) {
            d |= 2;
        }
        return d;
    }

    @Override
    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        if (this.argument.length == 0) {
            return this;
        }
        return Literal.makeLiteral((Value)((Object)this.evaluateItem(visitor.getStaticContext().makeEarlyEvaluationContext())));
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        if (this.argument.length == 0 && contextItemType == null) {
            XPathException err = new XPathException("The context item for string-length() is undefined");
            err.setErrorCode("XPDY0002");
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
        return super.typeCheck(visitor, contextItemType);
    }

    @Override
    public Item evaluateItem(XPathContext c) throws XPathException {
        AtomicValue sv;
        if (this.argument.length == 0) {
            Item contextItem = c.getContextItem();
            if (contextItem == null) {
                this.dynamicError("The context item for string-length() is not set", "XPDY0002", c);
                return null;
            }
            sv = StringValue.makeStringValue(contextItem.getStringValueCS());
        } else {
            sv = (AtomicValue)this.argument[0].evaluateItem(c);
        }
        if (sv == null) {
            return Int64Value.ZERO;
        }
        if (sv instanceof StringValue) {
            return Int64Value.makeIntegerValue(((StringValue)sv).getStringLength());
        }
        CharSequence s = sv.getStringValueCS();
        return Int64Value.makeIntegerValue(StringValue.getStringLength(s));
    }
}

