/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.functions;

import net2.sf.saxon.event.SequenceReceiver;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.functions.SystemFunction;
import net2.sf.saxon.om.FastStringBuffer;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.value.Cardinality;
import net2.sf.saxon.value.StringValue;

public class StringJoin
extends SystemFunction {
    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression exp = super.optimize(visitor, contextItemType);
        if (exp instanceof StringJoin) {
            return ((StringJoin)exp).simplifySingleton();
        }
        return exp;
    }

    private Expression simplifySingleton() {
        int card = this.argument[0].getCardinality();
        if (!Cardinality.allowsMany(card)) {
            if (Cardinality.allowsZero(card)) {
                return SystemFunction.makeSystemFunction("string", new Expression[]{this.argument[0]});
            }
            return this.argument[0];
        }
        return this;
    }

    @Override
    public Item evaluateItem(XPathContext c) throws XPathException {
        SequenceIterator iter = this.argument[0].iterate(c);
        Item it = iter.next();
        if (it == null) {
            return StringValue.EMPTY_STRING;
        }
        CharSequence first = it.getStringValueCS();
        it = iter.next();
        if (it == null) {
            return StringValue.makeStringValue(first);
        }
        FastStringBuffer sb = new FastStringBuffer(64);
        sb.append(first);
        CharSequence sep = this.argument[1].evaluateItem(c).getStringValueCS();
        sb.append(sep);
        sb.append(it.getStringValueCS());
        while ((it = iter.next()) != null) {
            sb.append(sep);
            sb.append(it.getStringValueCS());
        }
        return StringValue.makeStringValue(sb.condense());
    }

    @Override
    public void process(XPathContext context) throws XPathException {
        SequenceReceiver out = context.getReceiver();
        out.append(StringValue.EMPTY_STRING, 0, 0);
        SequenceIterator iter = this.argument[0].iterate(context);
        Item it = iter.next();
        if (it == null) {
            return;
        }
        CharSequence first = it.getStringValueCS();
        out.characters(first, 0, 0);
        it = iter.next();
        if (it == null) {
            out.append(StringValue.EMPTY_STRING, 0, 0);
            return;
        }
        CharSequence sep = this.argument[1].evaluateItem(context).getStringValueCS();
        out.characters(sep, 0, 0);
        out.characters(it.getStringValueCS(), 0, 0);
        while ((it = iter.next()) != null) {
            out.characters(sep, 0, 0);
            out.characters(it.getStringValueCS(), 0, 0);
        }
        out.append(StringValue.EMPTY_STRING, 0, 0);
    }
}

