/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.functions;

import java.util.regex.PatternSyntaxException;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.functions.Matches;
import net2.sf.saxon.functions.SystemFunction;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.regex.JRegularExpression;
import net2.sf.saxon.regex.RegularExpression;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.StringValue;

public class Replace
extends SystemFunction {
    private RegularExpression regexp;

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        Expression e = this.simplifyArguments(visitor);
        if (e == this) {
            this.maybePrecompile(visitor);
        }
        return e;
    }

    private void maybePrecompile(ExpressionVisitor visitor) throws XPathException {
        if (this.regexp == null) {
            try {
                this.regexp = Matches.tryToCompile(this.argument, 1, 3, visitor.getStaticContext());
            }
            catch (XPathException err) {
                err.setLocator(this);
                throw err;
            }
            if (this.regexp != null && this.regexp.matches("")) {
                err = new XPathException("The regular expression in replace() must not be one that matches a zero-length string");
                err.setErrorCode("FORX0003");
                err.setLocator(this);
                throw err;
            }
        }
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression e = super.optimize(visitor, contextItemType);
        if (e == this) {
            this.maybePrecompile(visitor);
        }
        return e;
    }

    public RegularExpression getCompiledRegularExpression() {
        return this.regexp;
    }

    @Override
    public Item evaluateItem(XPathContext c) throws XPathException {
        RegularExpression re;
        AtomicValue arg2;
        CharSequence replacement;
        String msg;
        AtomicValue arg0 = (AtomicValue)this.argument[0].evaluateItem(c);
        if (arg0 == null) {
            arg0 = StringValue.EMPTY_STRING;
        }
        if ((msg = Replace.checkReplacement(replacement = (arg2 = (AtomicValue)this.argument[2].evaluateItem(c)).getStringValueCS())) != null) {
            this.dynamicError(msg, "FORX0004", c);
        }
        if ((re = this.regexp) == null) {
            CharSequence flags;
            AtomicValue arg1 = (AtomicValue)this.argument[1].evaluateItem(c);
            if (this.argument.length == 3) {
                flags = "";
            } else {
                AtomicValue arg3 = (AtomicValue)this.argument[3].evaluateItem(c);
                flags = arg3.getStringValueCS();
            }
            try {
                int xmlVersion = c.getConfiguration().getXMLVersion();
                int flagBits = JRegularExpression.setFlags(flags);
                re = new JRegularExpression(arg1.getStringValueCS(), xmlVersion, 0, flagBits);
            }
            catch (XPathException err) {
                XPathException de = new XPathException(err);
                de.setErrorCode("FORX0002");
                de.setXPathContext(c);
                de.setLocator(this);
                throw de;
            }
            catch (PatternSyntaxException err) {
                XPathException de = new XPathException(err);
                de.setErrorCode("FORX0002");
                de.setXPathContext(c);
                de.setLocator(this);
                throw de;
            }
            if (re.matches("")) {
                this.dynamicError("The regular expression in replace() must not be one that matches a zero-length string", "FORX0003", c);
            }
        }
        String input = arg0.getStringValue();
        CharSequence res = re.replace(input, replacement);
        return StringValue.makeStringValue(res);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String checkReplacement(CharSequence rep) {
        int i = 0;
        while (i < rep.length()) {
            char next;
            char c = rep.charAt(i);
            if (c == '$') {
                if (i + 1 >= rep.length()) return "Invalid replacement string in replace(): $ sign at end of string";
                if ((next = rep.charAt(++i)) < '0' || next > '9') {
                    return "Invalid replacement string in replace(): $ sign must be followed by digit 0-9";
                }
            } else if (c == '\\') {
                if (i + 1 >= rep.length()) return "Invalid replacement string in replace(): \\ character at end of string";
                if ((next = rep.charAt(++i)) != '\\' && next != '$') {
                    return "Invalid replacement string in replace(): \\ character must be followed by \\ or $";
                }
            }
            ++i;
        }
        return null;
    }
}

