/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.functions;

import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionTool;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.LastPositionFinder;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.expr.TailExpression;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.functions.SystemFunction;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.IntegerValue;
import net2.sf.saxon.value.NumericValue;

public class Remove
extends SystemFunction {
    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        Expression exp = super.simplify(visitor);
        if (exp instanceof Remove) {
            return ((Remove)exp).simplifyAsTailExpression();
        }
        return exp;
    }

    private Expression simplifyAsTailExpression() {
        if (Literal.isAtomic(this.argument[1])) {
            try {
                long value = ((IntegerValue)((Literal)this.argument[1]).getValue()).longValue();
                if (value <= 0L) {
                    return this.argument[0];
                }
                if (value == 1L) {
                    TailExpression t = new TailExpression(this.argument[0], 2);
                    ExpressionTool.copyLocationInfo(this, t);
                    return t;
                }
            }
            catch (XPathException err) {
                return this;
            }
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression e = super.optimize(visitor, contextItemType);
        if (e == this) {
            return this.simplifyAsTailExpression();
        }
        return e;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return this.argument[0].getItemType(th);
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator seq = this.argument[0].iterate(context);
        AtomicValue n0 = (AtomicValue)this.argument[1].evaluateItem(context);
        NumericValue n = (NumericValue)n0;
        int pos = (int)n.longValue();
        if (pos < 1) {
            return seq;
        }
        return new RemoveIterator(seq, pos);
    }

    public static class RemoveIterator
    implements SequenceIterator,
    LastPositionFinder {
        SequenceIterator base;
        int removePosition;
        int position = 0;
        Item current = null;

        public RemoveIterator(SequenceIterator base, int removePosition) {
            this.base = base;
            this.removePosition = removePosition;
        }

        @Override
        public Item next() throws XPathException {
            this.current = this.base.next();
            if (this.current != null && this.base.position() == this.removePosition) {
                this.current = this.base.next();
            }
            this.position = this.current == null ? -1 : ++this.position;
            return this.current;
        }

        @Override
        public Item current() {
            return this.current;
        }

        @Override
        public int position() {
            return this.position;
        }

        @Override
        public void close() {
            this.base.close();
        }

        @Override
        public int getLastPosition() throws XPathException {
            if (this.base instanceof LastPositionFinder) {
                int x = ((LastPositionFinder)this.base).getLastPosition();
                if (this.removePosition >= 1 && this.removePosition <= x) {
                    return x - 1;
                }
                return x;
            }
            throw new AssertionError((Object)"base of removeIterator is not a LastPositionFinder");
        }

        @Override
        public SequenceIterator getAnother() throws XPathException {
            return new RemoveIterator(this.base.getAnother(), this.removePosition);
        }

        @Override
        public int getProperties() {
            return this.base.getProperties() & 2;
        }
    }
}

