/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.functions;

import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.ItemMappingFunction;
import net2.sf.saxon.expr.PathMap;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.functions.SystemFunction;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ConversionResult;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.ValidationFailure;
import net2.sf.saxon.value.AnyURIValue;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.BooleanValue;
import net2.sf.saxon.value.DoubleValue;
import net2.sf.saxon.value.NumericValue;
import net2.sf.saxon.value.StringValue;
import net2.sf.saxon.value.Value;

public class NumberFn
extends SystemFunction
implements ItemMappingFunction {
    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.useContextItemAsDefault();
        this.argument[0].setFlattened(true);
        return this.simplifyArguments(visitor);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression e2 = super.typeCheck(visitor, contextItemType);
        if (e2 != this) {
            return e2;
        }
        if (this.argument[0] instanceof NumberFn) {
            this.argument[0] = ((NumberFn)this.argument[0]).argument[0];
        }
        return this;
    }

    @Override
    public PathMap.PathMapNodeSet addDocToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodes) {
        PathMap.PathMapNodeSet result = this.argument[0].addToPathMap(pathMap, pathMapNodes);
        if (result != null) {
            result.setAtomized();
        }
        return null;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        Item arg0 = this.argument[0].evaluateItem(context);
        if (arg0 == null) {
            return DoubleValue.NaN;
        }
        if (arg0 instanceof BooleanValue || arg0 instanceof NumericValue) {
            ConversionResult result = ((AtomicValue)arg0).convert(BuiltInAtomicType.DOUBLE, true, context);
            if (result instanceof ValidationFailure) {
                return DoubleValue.NaN;
            }
            return (AtomicValue)result;
        }
        if (arg0 instanceof StringValue && !(arg0 instanceof AnyURIValue)) {
            CharSequence s = arg0.getStringValueCS();
            try {
                return new DoubleValue(Value.stringToNumber(s));
            }
            catch (NumberFormatException e) {
                return DoubleValue.NaN;
            }
        }
        return DoubleValue.NaN;
    }

    public static DoubleValue convert(AtomicValue value) {
        try {
            if (value == null) {
                return DoubleValue.NaN;
            }
            if (value instanceof BooleanValue || value instanceof NumericValue) {
                ConversionResult result = value.convert(BuiltInAtomicType.DOUBLE, true, null);
                if (result instanceof ValidationFailure) {
                    return DoubleValue.NaN;
                }
                return (DoubleValue)result;
            }
            if (value instanceof StringValue && !(value instanceof AnyURIValue)) {
                CharSequence s = value.getStringValueCS();
                return new DoubleValue(Value.stringToNumber(s));
            }
            return DoubleValue.NaN;
        }
        catch (NumberFormatException e) {
            return DoubleValue.NaN;
        }
    }

    @Override
    public Item map(Item item) throws XPathException {
        return NumberFn.convert((AtomicValue)item);
    }
}

