/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.functions;

import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.functions.SystemFunction;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.AtomicType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.value.BooleanValue;

public class Lang
extends SystemFunction {
    @Override
    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        if (this.argument.length == 1) {
            if (contextItemType == null) {
                XPathException err = new XPathException("The context item for lang() is undefined");
                err.setErrorCode("XPDY0002");
                err.setIsTypeError(true);
                err.setLocator(this);
                throw err;
            }
            if (contextItemType instanceof AtomicType) {
                XPathException err = new XPathException("The context item for lang() is not a node");
                err.setErrorCode("XPTY0004");
                err.setIsTypeError(true);
                err.setLocator(this);
                throw err;
            }
        }
        return super.typeCheck(visitor, contextItemType);
    }

    @Override
    public Item evaluateItem(XPathContext c) throws XPathException {
        NodeInfo target;
        if (this.argument.length > 1) {
            target = (NodeInfo)this.argument[1].evaluateItem(c);
        } else {
            Item current = c.getContextItem();
            if (current == null) {
                XPathException err = new XPathException("The context item is undefined");
                err.setErrorCode("XPDY0002");
                err.setXPathContext(c);
                throw err;
            }
            if (!(current instanceof NodeInfo)) {
                XPathException err = new XPathException("The context item is not a node");
                err.setErrorCode("XPTY0004");
                err.setXPathContext(c);
                throw err;
            }
            target = (NodeInfo)current;
        }
        Item arg0Val = this.argument[0].evaluateItem(c);
        String testLang = arg0Val == null ? "" : arg0Val.getStringValue();
        boolean b = Lang.isLang(testLang, target);
        return BooleanValue.get(b);
    }

    @Override
    public int getIntrinsicDependencies() {
        return this.argument.length == 1 ? 2 : 0;
    }

    public static boolean isLang(String arglang, NodeInfo target) {
        String doclang = null;
        NodeInfo node = target;
        while (node != null) {
            doclang = node.getAttributeValue(387);
            if (doclang != null) break;
            if ((node = node.getParent()) != null) continue;
            return false;
        }
        if (doclang == null) {
            return false;
        }
        while (!arglang.equalsIgnoreCase(doclang)) {
            int hyphen = doclang.indexOf("-");
            if (hyphen < 0) {
                return false;
            }
            doclang = doclang.substring(0, hyphen);
        }
        return true;
    }
}

