/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.functions;

import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.expr.StaticContext;
import net2.sf.saxon.expr.TailIterator;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.functions.ExtensionFunctionCall;
import net2.sf.saxon.functions.ExtensionFunctionDefinition;
import net2.sf.saxon.om.EmptyIterator;
import net2.sf.saxon.om.GroundedIterator;
import net2.sf.saxon.om.GroundedValue;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.SingletonIterator;
import net2.sf.saxon.om.StructuredQName;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.Cardinality;
import net2.sf.saxon.value.EmptySequence;
import net2.sf.saxon.value.NumericValue;
import net2.sf.saxon.value.SequenceType;

public class ItemAt
extends ExtensionFunctionDefinition {
    private static final StructuredQName qName = new StructuredQName("", "http://saxon.sf.net/", "item-at");
    private static SequenceType[] argumentTypes = new SequenceType[]{SequenceType.ANY_SEQUENCE, SequenceType.OPTIONAL_NUMERIC};

    @Override
    public StructuredQName getFunctionQName() {
        return qName;
    }

    @Override
    public int getMinimumNumberOfArguments() {
        return 2;
    }

    @Override
    public int getMaximumNumberOfArguments() {
        return 2;
    }

    @Override
    public SequenceType[] getArgumentTypes() {
        return argumentTypes;
    }

    @Override
    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.makeSequenceType(suppliedArgumentTypes[0].getPrimaryType(), 24576);
    }

    @Override
    public ExtensionFunctionCall makeCallExpression() {
        return new ItemAtCall();
    }

    @Override
    public Object getCompilerForJava() {
        try {
            return Class.forName("com.saxonica.codegen.ItemAtCompiler").newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static class ItemAtCall
    extends ExtensionFunctionCall {
        private ItemAtCall() {
        }

        @Override
        public Expression rewrite(StaticContext context, Expression[] arguments) throws XPathException {
            if (arguments[1] instanceof Literal) {
                NumericValue val = (NumericValue)((Literal)arguments[1]).getValue();
                if (val.compareTo(1L) < 0 || val.compareTo(Integer.MAX_VALUE) > 0 || !val.isWholeNumber()) {
                    return new Literal(EmptySequence.getInstance());
                }
                if (val.compareTo(1L) > 0 && !Cardinality.allowsMany(arguments[0].getCardinality())) {
                    return new Literal(EmptySequence.getInstance());
                }
            }
            return null;
        }

        @Override
        public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
            NumericValue index = (NumericValue)arguments[1].next();
            if (index == null) {
                return EmptyIterator.getInstance();
            }
            if (index.compareTo(Integer.MAX_VALUE) <= 0 && index.isWholeNumber()) {
                Item item;
                int intindex = (int)index.longValue();
                if (intindex < 1) {
                    return EmptyIterator.getInstance();
                }
                SequenceIterator base = arguments[0];
                if (intindex == 1) {
                    item = base.next();
                } else if (base instanceof GroundedIterator) {
                    GroundedValue value = ((GroundedIterator)base).materialize();
                    item = value.itemAt(intindex - 1);
                } else {
                    SequenceIterator tail = TailIterator.make(base, intindex);
                    item = tail.next();
                }
                return SingletonIterator.makeIterator(item);
            }
            return EmptyIterator.getInstance();
        }
    }
}

