/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.functions;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.StaticContext;
import net2.sf.saxon.functions.ExtensionFunctionCall;
import net2.sf.saxon.functions.ExtensionFunctionDefinition;
import net2.sf.saxon.functions.FunctionLibrary;
import net2.sf.saxon.functions.IntegratedFunctionCall;
import net2.sf.saxon.om.StructuredQName;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.SequenceType;

public class IntegratedFunctionLibrary
implements FunctionLibrary,
Serializable {
    private HashMap<StructuredQName, ExtensionFunctionDefinition> functions = new HashMap();

    public void registerFunction(ExtensionFunctionDefinition function) throws XPathException {
        this.functions.put(function.getFunctionQName(), function);
    }

    @Override
    public SequenceType[] getFunctionSignature(StructuredQName functionName, int arity) {
        ExtensionFunctionDefinition defn = this.functions.get(functionName);
        if (defn == null) {
            return null;
        }
        if (arity == -1) {
            return new SequenceType[0];
        }
        try {
            if (defn.getMinimumNumberOfArguments() <= arity && defn.getMaximumNumberOfArguments() >= arity) {
                SequenceType[] sig = new SequenceType[arity + 1];
                sig[0] = defn.getResultType(defn.getArgumentTypes());
                System.arraycopy(defn.getArgumentTypes(), 0, sig, 1, arity);
                return sig;
            }
            return null;
        }
        catch (Exception err) {
            return null;
        }
    }

    @Override
    public Expression bind(StructuredQName functionName, Expression[] staticArgs, StaticContext env) throws XPathException {
        ExtensionFunctionDefinition defn = this.functions.get(functionName);
        if (defn == null) {
            return null;
        }
        try {
            ExtensionFunctionCall f = defn.makeCallExpression();
            f.setDefinition(defn);
            IntegratedFunctionCall fc = new IntegratedFunctionCall(f);
            fc.setFunctionName(functionName);
            fc.setArguments(staticArgs);
            return fc;
        }
        catch (Exception err) {
            throw new XPathException("Failed to create call to extension function " + functionName.getDisplayName(), err);
        }
    }

    @Override
    public FunctionLibrary copy() {
        IntegratedFunctionLibrary lib = new IntegratedFunctionLibrary();
        lib.functions = new HashMap<StructuredQName, ExtensionFunctionDefinition>(this.functions);
        return lib;
    }

    public Iterator<StructuredQName> iterateFunctionNames() {
        return this.functions.keySet().iterator();
    }
}

