/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.functions;

import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.functions.CollatingFunction;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.sort.GenericAtomicComparer;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.Type;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.Int64Value;

public class IndexOf
extends CollatingFunction {
    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        GenericAtomicComparer comparer = this.getAtomicComparer(2, context);
        SequenceIterator seq = this.argument[0].iterate(context);
        AtomicValue val = (AtomicValue)this.argument[1].evaluateItem(context);
        return new IndexIterator(seq, val, comparer);
    }

    public static class IndexIterator
    implements SequenceIterator {
        SequenceIterator base;
        AtomicValue value;
        GenericAtomicComparer comparer;
        int index = 0;
        int position = 0;
        Item current = null;
        BuiltInAtomicType primitiveTypeRequired;
        TypeHierarchy typeHierarchy;

        public IndexIterator(SequenceIterator base, AtomicValue value, GenericAtomicComparer comparer) {
            this.base = base;
            this.value = value;
            this.comparer = comparer;
            this.primitiveTypeRequired = value.getPrimitiveType();
        }

        @Override
        public Item next() throws XPathException {
            AtomicValue i;
            while ((i = (AtomicValue)this.base.next()) != null) {
                ++this.index;
                if (!Type.isComparable(this.primitiveTypeRequired, i.getPrimitiveType(), false)) continue;
                try {
                    if (!this.comparer.comparesEqual(i, this.value)) continue;
                    this.current = Int64Value.makeIntegerValue(this.index);
                    ++this.position;
                    return this.current;
                }
                catch (ClassCastException classCastException) {
                }
            }
            this.current = null;
            this.position = -1;
            return null;
        }

        @Override
        public Item current() {
            return this.current;
        }

        @Override
        public int position() {
            return this.position;
        }

        @Override
        public void close() {
            this.base.close();
        }

        @Override
        public SequenceIterator getAnother() throws XPathException {
            return new IndexIterator(this.base.getAnother(), this.value, this.comparer);
        }

        @Override
        public int getProperties() {
            return 0;
        }
    }
}

