/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.functions;

import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.functions.SystemFunction;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.om.NamespaceCodeIterator;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.sort.IntIterator;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.value.StringValue;

public class InScopePrefixes
extends SystemFunction {
    @Override
    public SequenceIterator iterate(final XPathContext context) throws XPathException {
        NodeInfo element = (NodeInfo)this.argument[0].evaluateItem(context);
        final IntIterator iter = NamespaceCodeIterator.iterateNamespaces(element);
        final NamePool pool = context.getNamePool();
        return new SequenceIterator(){
            private Item current = null;
            private int position = 0;

            @Override
            public Item current() {
                return this.current;
            }

            @Override
            public SequenceIterator getAnother() throws XPathException {
                return InScopePrefixes.this.iterate(context);
            }

            @Override
            public int getProperties() {
                return 0;
            }

            @Override
            public Item next() throws XPathException {
                if (this.position == 0) {
                    this.current = new StringValue("xml");
                    ++this.position;
                    return this.current;
                }
                if (iter.hasNext()) {
                    String prefix = pool.getPrefixFromNamespaceCode(iter.next());
                    this.current = prefix.length() == 0 ? StringValue.EMPTY_STRING : StringValue.makeRestrictedString(prefix, BuiltInAtomicType.NCNAME, null).asAtomic();
                    ++this.position;
                    return this.current;
                }
                this.current = null;
                this.position = -1;
                return null;
            }

            @Override
            public int position() {
                return this.position;
            }

            @Override
            public void close() {
            }
        };
    }
}

