/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.functions;

import net2.sf.saxon.Controller;
import net2.sf.saxon.expr.AxisExpression;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionTool;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.MappingFunction;
import net2.sf.saxon.expr.MappingIterator;
import net2.sf.saxon.expr.Optimizer;
import net2.sf.saxon.expr.PathMap;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.functions.SystemFunction;
import net2.sf.saxon.om.DocumentInfo;
import net2.sf.saxon.om.EmptyIterator;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.StandardNames;
import net2.sf.saxon.pattern.AnyNodeTest;
import net2.sf.saxon.sort.DocumentOrderIterator;
import net2.sf.saxon.sort.LocalOrderComparer;
import net2.sf.saxon.trans.KeyDefinitionSet;
import net2.sf.saxon.trans.KeyManager;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.Cardinality;
import net2.sf.saxon.value.StringValue;

public class Idref
extends SystemFunction {
    private KeyDefinitionSet idRefKey;

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        Idref f = (Idref)super.simplify(visitor);
        f.addContextDocumentArgument(1, "idref");
        return f;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression e = super.typeCheck(visitor, contextItemType);
        this.idRefKey = visitor.getExecutable().getKeyManager().getKeyDefinitionSet(StandardNames.getStructuredQName(562));
        return e;
    }

    @Override
    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        super.checkArguments(visitor);
        Optimizer opt = visitor.getConfiguration().getOptimizer();
        this.argument[0] = ExpressionTool.unsorted(opt, this.argument[0], false);
    }

    @Override
    public int computeSpecialProperties() {
        int prop = 0xC20000;
        if (this.getNumberOfArguments() == 1 || (this.argument[1].getSpecialProperties() & 0x10000) != 0) {
            prop |= 0x10000;
        }
        return prop;
    }

    @Override
    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    @Override
    public Expression copy() {
        Idref i2 = (Idref)super.copy();
        i2.idRefKey = this.idRefKey;
        return i2;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        this.argument[0].addToPathMap(pathMap, pathMapNodeSet);
        PathMap.PathMapNodeSet target = this.argument[1].addToPathMap(pathMap, pathMapNodeSet);
        AxisExpression allElements = new AxisExpression(4, AnyNodeTest.getInstance());
        allElements.setContainer(this.getContainer());
        target = target.createArc(allElements);
        return target;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        NodeInfo arg2 = (NodeInfo)this.argument[1].evaluateItem(context);
        if ((arg2 = arg2.getRoot()).getNodeKind() != 9) {
            this.dynamicError("In the idref() function, the tree being searched must be one whose root is a document node", "FODC0001", context);
            return null;
        }
        DocumentInfo doc = (DocumentInfo)arg2;
        Expression expression = this.argument[0];
        if (Cardinality.allowsMany(expression.getCardinality())) {
            SequenceIterator keys = this.argument[0].iterate(context);
            return Idref.getIdrefMultiple(doc, keys, context);
        }
        AtomicValue keyValue = (AtomicValue)this.argument[0].evaluateItem(context);
        if (keyValue == null) {
            return EmptyIterator.getInstance();
        }
        KeyManager keyManager = controller.getKeyManager();
        return keyManager.selectByKey(this.idRefKey, doc, keyValue, context);
    }

    public static SequenceIterator getIdrefMultiple(DocumentInfo doc, SequenceIterator keys, XPathContext context) throws XPathException {
        IdrefMappingFunction map = new IdrefMappingFunction();
        map.document = doc;
        map.keyContext = context;
        map.keyManager = context.getController().getKeyManager();
        map.keySet = map.keyManager.getKeyDefinitionSet(StandardNames.getStructuredQName(562));
        MappingIterator allValues = new MappingIterator(keys, map);
        return new DocumentOrderIterator(allValues, LocalOrderComparer.getInstance());
    }

    private static class IdrefMappingFunction
    implements MappingFunction {
        public DocumentInfo document;
        public XPathContext keyContext;
        public KeyManager keyManager;
        public KeyDefinitionSet keySet;

        private IdrefMappingFunction() {
        }

        @Override
        public SequenceIterator map(Item item) throws XPathException {
            KeyManager keyManager = this.keyContext.getController().getKeyManager();
            AtomicValue keyValue = item instanceof AtomicValue ? (AtomicValue)item : new StringValue(item.getStringValue());
            return keyManager.selectByKey(this.keySet, this.document, keyValue, this.keyContext);
        }
    }
}

