/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.functions;

import java.util.ArrayList;
import java.util.List;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.StaticContext;
import net2.sf.saxon.functions.FunctionLibrary;
import net2.sf.saxon.om.StructuredQName;
import net2.sf.saxon.query.XQueryFunction;
import net2.sf.saxon.query.XQueryFunctionBinder;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.SequenceType;

public class FunctionLibraryList
implements FunctionLibrary,
XQueryFunctionBinder {
    public List libraryList = new ArrayList(8);

    public int addFunctionLibrary(FunctionLibrary lib) {
        this.libraryList.add(lib);
        return this.libraryList.size() - 1;
    }

    public FunctionLibrary get(int n) {
        return (FunctionLibrary)this.libraryList.get(n);
    }

    @Override
    public SequenceType[] getFunctionSignature(StructuredQName functionName, int arity) {
        for (FunctionLibrary lib : this.libraryList) {
            SequenceType[] sig = lib.getFunctionSignature(functionName, arity);
            if (sig == null) continue;
            return sig;
        }
        return null;
    }

    @Override
    public Expression bind(StructuredQName functionName, Expression[] staticArgs, StaticContext env) throws XPathException {
        boolean debug = env.getConfiguration().isTraceExternalFunctions();
        if (debug) {
            System.err.println("Looking for function " + functionName.getClarkName());
        }
        for (FunctionLibrary lib : this.libraryList) {
            Expression func;
            if (debug) {
                System.err.println("Trying " + lib.getClass().getName());
            }
            if ((func = lib.bind(functionName, staticArgs, env)) == null) continue;
            return func;
        }
        if (debug) {
            System.err.println("Function " + functionName.getClarkName() + " not found!");
        }
        return null;
    }

    @Override
    public XQueryFunction getDeclaration(StructuredQName functionName, Expression[] staticArgs) {
        for (FunctionLibrary lib : this.libraryList) {
            XQueryFunction func;
            if (!(lib instanceof XQueryFunctionBinder) || (func = ((XQueryFunctionBinder)lib).getDeclaration(functionName, staticArgs)) == null) continue;
            return func;
        }
        return null;
    }

    public List getLibraryList() {
        return this.libraryList;
    }

    @Override
    public FunctionLibrary copy() {
        FunctionLibraryList fll = new FunctionLibraryList();
        fll.libraryList = new ArrayList(this.libraryList.size());
        int i = 0;
        while (i < this.libraryList.size()) {
            fll.libraryList.add(((FunctionLibrary)this.libraryList.get(i)).copy());
            ++i;
        }
        return fll;
    }
}

