/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.functions;

import net2.sf.saxon.expr.BooleanExpression;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionTool;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.FunctionCall;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.expr.Negatable;
import net2.sf.saxon.expr.Optimizer;
import net2.sf.saxon.expr.VennExpression;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.functions.SystemFunction;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.LookaheadIterator;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.value.BooleanValue;

public class Existence
extends SystemFunction
implements Negatable {
    public static final int EXISTS = 0;
    public static final int EMPTY = 1;

    @Override
    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        super.checkArguments(visitor);
        Optimizer opt = visitor.getConfiguration().getOptimizer();
        this.argument[0] = ExpressionTool.unsorted(opt, this.argument[0], false);
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        VennExpression v;
        Expression e2 = super.optimize(visitor, contextItemType);
        if (e2 != this) {
            return e2;
        }
        int c = this.argument[0].getCardinality();
        if (c == 49152) {
            return new Literal(BooleanValue.get(this.operation == 0));
        }
        if (c == 8192) {
            return new Literal(BooleanValue.get(this.operation == 1));
        }
        if (this.argument[0] instanceof VennExpression && (v = (VennExpression)this.argument[0]).getOperator() == 1) {
            int newop = this.operation == 0 ? 9 : 10;
            FunctionCall e0 = SystemFunction.makeSystemFunction(this.getFunctionName().getLocalName(), new Expression[]{v.getOperands()[0]});
            FunctionCall e1 = SystemFunction.makeSystemFunction(this.getFunctionName().getLocalName(), new Expression[]{v.getOperands()[1]});
            return new BooleanExpression(e0, newop, e1).optimize(visitor, contextItemType);
        }
        return this;
    }

    @Override
    public boolean isNegatable(ExpressionVisitor visitor) {
        return true;
    }

    @Override
    public Expression negate() {
        FunctionCall fc = SystemFunction.makeSystemFunction(this.operation == 0 ? "empty" : "exists", this.getArguments());
        fc.setLocationId(this.getLocationId());
        return fc;
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext c) throws XPathException {
        SequenceIterator iter = this.argument[0].iterate(c);
        boolean result = false;
        if ((iter.getProperties() & 4) != 0) {
            switch (this.operation) {
                case 0: {
                    result = ((LookaheadIterator)iter).hasNext();
                    break;
                }
                case 1: {
                    result = !((LookaheadIterator)iter).hasNext();
                }
            }
        } else {
            switch (this.operation) {
                case 0: {
                    result = iter.next() != null;
                    break;
                }
                case 1: {
                    result = iter.next() == null;
                }
            }
        }
        iter.close();
        return result;
    }

    @Override
    public Item evaluateItem(XPathContext c) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(c));
    }
}

