/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.functions;

import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionLocation;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.PendingUpdateList;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.functions.SystemFunction;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.sxpath.XPathEvaluator;
import net2.sf.saxon.sxpath.XPathExpression;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.value.QNameValue;
import net2.sf.saxon.value.QualifiedNameValue;
import net2.sf.saxon.value.SequenceExtent;
import net2.sf.saxon.value.SingletonItem;
import net2.sf.saxon.value.Value;

public class Error
extends SystemFunction {
    @Override
    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    @Override
    public boolean isVacuousExpression() {
        return true;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        QualifiedNameValue qname = null;
        if (this.argument.length > 0) {
            qname = (QualifiedNameValue)this.argument[0].evaluateItem(context);
        }
        if (qname == null) {
            qname = new QNameValue("err", "http://www.w3.org/2005/xqt-errors", this.argument.length == 1 ? "FOTY0004" : "FOER0000", BuiltInAtomicType.QNAME, null);
        }
        String description = this.argument.length > 1 ? this.argument[1].evaluateItem(context).getStringValue() : "Error signalled by application call on error()";
        XPathException e = new XPathException(description);
        e.setErrorCodeQName(qname.toStructuredQName());
        e.setXPathContext(context);
        e.setLocator(this);
        if (this.argument.length > 2) {
            Item root;
            Value errorObject = ((Value)SequenceExtent.makeSequenceExtent(this.argument[2].iterate(context))).reduce();
            if (errorObject instanceof SingletonItem && (root = ((SingletonItem)errorObject).getItem()) instanceof NodeInfo && ((NodeInfo)root).getNodeKind() == 9) {
                XPathEvaluator xpath = new XPathEvaluator();
                XPathExpression exp = xpath.createExpression("/error/@module");
                NodeInfo moduleAtt = (NodeInfo)exp.evaluateSingle((NodeInfo)root);
                String module = moduleAtt == null ? null : moduleAtt.getStringValue();
                exp = xpath.createExpression("/error/@line");
                NodeInfo lineAtt = (NodeInfo)exp.evaluateSingle((NodeInfo)root);
                int line = lineAtt == null ? -1 : Integer.parseInt(lineAtt.getStringValue());
                exp = xpath.createExpression("/error/@column");
                NodeInfo columnAtt = (NodeInfo)exp.evaluateSingle((NodeInfo)root);
                int column = columnAtt == null ? -1 : Integer.parseInt(columnAtt.getStringValue());
                ExpressionLocation locator = new ExpressionLocation();
                locator.setSystemId(module);
                locator.setLineNumber(line);
                locator.setColumnNumber(column);
                e.setLocator(locator);
            }
            e.setErrorObject(errorObject);
        }
        throw e;
    }

    @Override
    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        this.evaluateItem(context);
    }
}

