/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.functions;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import net2.sf.saxon.Controller;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.functions.Document;
import net2.sf.saxon.functions.SystemFunction;
import net2.sf.saxon.om.DocumentInfo;
import net2.sf.saxon.om.DocumentPool;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.BooleanValue;

public class DocAvailable
extends SystemFunction {
    private String expressionBaseURI = null;

    @Override
    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        if (this.expressionBaseURI == null) {
            super.checkArguments(visitor);
            this.expressionBaseURI = visitor.getStaticContext().getBaseURI();
        }
    }

    public String getStaticBaseURI() {
        return this.expressionBaseURI;
    }

    @Override
    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        AtomicValue hrefVal = (AtomicValue)this.argument[0].evaluateItem(context);
        if (hrefVal == null) {
            return BooleanValue.FALSE;
        }
        String href = hrefVal.getStringValue();
        Controller controller = context.getController();
        ErrorListener old = controller.getErrorListener();
        controller.setErrorListener(new ErrorListener(){

            @Override
            public void warning(TransformerException exception) {
            }

            @Override
            public void error(TransformerException exception) {
            }

            @Override
            public void fatalError(TransformerException exception) {
            }
        });
        try {
            boolean b = this.docAvailable(href, context);
            controller.setErrorListener(old);
            return BooleanValue.get(b);
        }
        catch (URISyntaxException err) {
            controller.setErrorListener(old);
            XPathException xe = new XPathException(err);
            xe.setErrorCode("FODC0005");
            xe.setXPathContext(context);
            xe.setLocator(this);
            throw xe;
        }
    }

    private boolean docAvailable(String href, XPathContext context) throws URISyntaxException {
        DocumentPool pool;
        String documentKey;
        block9: {
            block8: {
                block7: {
                    try {
                        documentKey = Document.computeDocumentKey(href, this.expressionBaseURI, context);
                        pool = context.getController().getDocumentPool();
                        if (!pool.isMarkedUnavailable(documentKey)) break block7;
                        return false;
                    }
                    catch (Exception err) {
                        new URI(href);
                        return false;
                    }
                }
                DocumentInfo doc = pool.find(documentKey);
                if (doc == null) break block8;
                return true;
            }
            NodeInfo item = Document.makeDoc(href, this.expressionBaseURI, context, this);
            if (item == null) break block9;
            return true;
        }
        pool.markUnavailable(documentKey);
        return false;
    }
}

