/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.functions;

import java.util.ArrayList;
import javax.xml.transform.TransformerException;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.functions.Aggregate;
import net2.sf.saxon.functions.CollatingFunction;
import net2.sf.saxon.om.AxisIterator;
import net2.sf.saxon.om.FastStringBuffer;
import net2.sf.saxon.om.FunctionItem;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.om.Navigator;
import net2.sf.saxon.om.NodeInfo;
import net2.sf.saxon.om.Orphan;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.pattern.NameTest;
import net2.sf.saxon.sort.GenericAtomicComparer;
import net2.sf.saxon.sort.IntHashSet;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ComplexType;
import net2.sf.saxon.type.SchemaType;
import net2.sf.saxon.type.Type;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.BooleanValue;
import net2.sf.saxon.value.SequenceExtent;
import net2.sf.saxon.value.StringValue;
import net2.sf.saxon.value.Whitespace;

public class DeepEqual
extends CollatingFunction {
    public static final int INCLUDE_NAMESPACES = 1;
    public static final int INCLUDE_PREFIXES = 2;
    public static final int INCLUDE_COMMENTS = 4;
    public static final int INCLUDE_PROCESSING_INSTRUCTIONS = 8;
    public static final int EXCLUDE_WHITESPACE_TEXT_NODES = 16;
    public static final int COMPARE_STRING_VALUES = 32;
    public static final int COMPARE_ANNOTATIONS = 64;
    public static final int WARNING_IF_FALSE = 128;
    public static final int JOIN_ADJACENT_TEXT_NODES = 256;
    private transient Configuration config = null;

    @Override
    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        this.config = visitor.getConfiguration();
        return super.preEvaluate(visitor);
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        GenericAtomicComparer collator = this.getAtomicComparer(2, context);
        SequenceIterator op1 = this.argument[0].iterate(context);
        SequenceIterator op2 = this.argument[1].iterate(context);
        Configuration config = this.config != null ? this.config : context.getConfiguration();
        try {
            return BooleanValue.get(DeepEqual.deepEquals(op1, op2, collator, config, 0));
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            e.maybeSetContext(context);
            throw e;
        }
    }

    public static boolean deepEquals(SequenceIterator op1, SequenceIterator op2, GenericAtomicComparer collator, Configuration config, int flags) throws XPathException {
        String reason;
        boolean result;
        block13: {
            result = true;
            reason = null;
            try {
                if ((flags & 0x100) != 0) {
                    op1 = DeepEqual.mergeAdjacentTextNodes(op1);
                    op2 = DeepEqual.mergeAdjacentTextNodes(op2);
                }
                while (true) {
                    Item item1 = op1.next();
                    Item item2 = op2.next();
                    if (item1 == null && item2 == null) break block13;
                    if (item1 == null || item2 == null) {
                        result = false;
                        reason = "sequences have different lengths";
                        break block13;
                    }
                    if (item1 instanceof FunctionItem || item2 instanceof FunctionItem) {
                        throw new XPathException("Argument to deep-equal() contains a function item", "FOTY0015");
                    }
                    if (item1 instanceof NodeInfo) {
                        if (item2 instanceof NodeInfo) {
                            if (DeepEqual.deepEquals((NodeInfo)item1, (NodeInfo)item2, collator, config, flags)) continue;
                            result = false;
                            reason = "nodes at position " + op1.position() + " differ";
                        } else {
                            result = false;
                            reason = "comparing a node to an atomic value at position " + op1.position();
                        }
                        break block13;
                    }
                    if (item2 instanceof NodeInfo) {
                        result = false;
                        reason = "comparing an atomic value to a node at position " + op1.position();
                        break block13;
                    }
                    AtomicValue av1 = (AtomicValue)item1;
                    AtomicValue av2 = (AtomicValue)item2;
                    if (!(av1.isNaN() && av2.isNaN() || collator.comparesEqual(av1, av2))) break;
                }
                result = false;
                reason = "atomic values at position " + op1.position() + " differ";
            }
            catch (ClassCastException err) {
                result = false;
                reason = "sequences contain non-comparable values";
            }
            catch (XPathException err) {
                if ("FOTY0015".equals(err.getErrorCodeLocalPart()) && "http://www.w3.org/2005/xqt-errors".equals(err.getErrorCodeNamespace())) {
                    throw err;
                }
                result = false;
                reason = "error occurred while comparing two values (" + err.getMessage() + ')';
            }
        }
        if (!result) {
            DeepEqual.explain(config, reason, flags);
        }
        return result;
    }

    private static boolean deepEquals(NodeInfo n1, NodeInfo n2, GenericAtomicComparer collator, Configuration config, int flags) throws XPathException {
        if (n1.isSameNodeInfo(n2)) {
            return true;
        }
        if (n1.getNodeKind() != n2.getNodeKind()) {
            DeepEqual.explain(config, "node kinds differ: comparing " + Type.displayTypeName(n1) + " to " + Type.displayTypeName(n2), flags);
            return false;
        }
        NamePool pool = config.getNamePool();
        switch (n1.getNodeKind()) {
            case 1: {
                NodeInfo att1;
                if (n1.getFingerprint() != n2.getFingerprint()) {
                    DeepEqual.explain(config, "element names differ: " + config.getNamePool().getClarkName(n1.getFingerprint()) + " != " + config.getNamePool().getClarkName(n2.getFingerprint()), flags);
                    return false;
                }
                if ((flags & 2) != 0 && n1.getNameCode() != n2.getNameCode()) {
                    DeepEqual.explain(config, "element prefixes differ: " + n1.getPrefix() + " != " + n2.getPrefix(), flags);
                    return false;
                }
                AxisIterator a1 = n1.iterateAxis((byte)2);
                AxisIterator a2 = n2.iterateAxis((byte)2);
                if (Aggregate.count(a1.getAnother()) != Aggregate.count(a2)) {
                    DeepEqual.explain(config, "elements have different number of attributes", flags);
                    return false;
                }
                while ((att1 = (NodeInfo)a1.next()) != null) {
                    AxisIterator a2iter = n2.iterateAxis((byte)2, new NameTest(2, att1.getFingerprint(), pool));
                    NodeInfo att2 = (NodeInfo)a2iter.next();
                    if (att2 == null) {
                        DeepEqual.explain(config, "one element has an attribute " + config.getNamePool().getClarkName(att1.getFingerprint()) + ", the other does not", flags);
                        return false;
                    }
                    if (DeepEqual.deepEquals(att1, att2, collator, config, flags)) continue;
                    DeepEqual.explain(config, "elements have different values for the attribute " + config.getNamePool().getClarkName(att1.getFingerprint()), flags);
                    return false;
                }
                if ((flags & 1) != 0) {
                    NodeInfo nn2;
                    NodeInfo nn1;
                    IntHashSet ns1 = new IntHashSet(10);
                    IntHashSet ns2 = new IntHashSet(10);
                    AxisIterator it1 = n1.iterateAxis((byte)8);
                    while ((nn1 = (NodeInfo)it1.next()) != null) {
                        int nscode1 = pool.getNamespaceCode(nn1.getLocalPart(), nn1.getStringValue());
                        ns1.add(nscode1);
                    }
                    AxisIterator it2 = n2.iterateAxis((byte)8);
                    while ((nn2 = (NodeInfo)it2.next()) != null) {
                        int nscode2 = pool.getNamespaceCode(nn2.getLocalPart(), nn2.getStringValue());
                        ns2.add(nscode2);
                    }
                    if (!ns1.equals(ns2)) {
                        DeepEqual.explain(config, "elements have different in-scope namespaces", flags);
                        return false;
                    }
                }
                if ((flags & 0x40) != 0 && n1.getTypeAnnotation() != n2.getTypeAnnotation()) {
                    DeepEqual.explain(config, "elements have different type annotation", flags);
                    return false;
                }
                if ((flags & 0x20) == 0) {
                    boolean isSimple2;
                    int ann1 = n1.getTypeAnnotation();
                    int ann2 = n2.getTypeAnnotation();
                    if (ann1 == -1) {
                        ann1 = 630;
                    }
                    if (ann2 == -1) {
                        ann2 = 630;
                    }
                    SchemaType type1 = config.getSchemaType(ann1);
                    SchemaType type2 = config.getSchemaType(ann2);
                    boolean isSimple1 = type1.isSimpleType() || ((ComplexType)type1).isSimpleContent();
                    boolean bl = isSimple2 = type2.isSimpleType() || ((ComplexType)type2).isSimpleContent();
                    if (isSimple1 != isSimple2) {
                        DeepEqual.explain(config, "one element has a simple type, the other does not", flags);
                        return false;
                    }
                    if (isSimple1 && isSimple2) {
                        SequenceIterator v1 = n1.getTypedValue();
                        SequenceIterator v2 = n2.getTypedValue();
                        return DeepEqual.deepEquals(v1, v2, collator, config, flags);
                    }
                }
            }
            case 9: {
                NodeInfo d2;
                NodeInfo d1;
                AxisIterator c1 = n1.iterateAxis((byte)3);
                AxisIterator c2 = n2.iterateAxis((byte)3);
                do {
                    boolean r;
                    d1 = (NodeInfo)c1.next();
                    while (d1 != null && DeepEqual.isIgnorable(d1, flags)) {
                        d1 = (NodeInfo)c1.next();
                    }
                    d2 = (NodeInfo)c2.next();
                    while (d2 != null && DeepEqual.isIgnorable(d2, flags)) {
                        d2 = (NodeInfo)c2.next();
                    }
                    if (d1 != null && d2 != null) continue;
                    boolean bl = r = d1 == d2;
                    if (!r) {
                        DeepEqual.explain(config, "nodes have different numbers of children", flags);
                    }
                    return r;
                } while (DeepEqual.deepEquals(d1, d2, collator, config, flags));
                return false;
            }
            case 2: {
                if (n1.getFingerprint() != n2.getFingerprint()) {
                    DeepEqual.explain(config, "attribute names differ: " + config.getNamePool().getClarkName(n1.getFingerprint()) + " != " + config.getNamePool().getClarkName(n2.getFingerprint()), flags);
                    return false;
                }
                if ((flags & 2) != 0 && n1.getNameCode() != n2.getNameCode()) {
                    DeepEqual.explain(config, "attribute prefixes differ: " + n1.getPrefix() + " != " + n2.getPrefix(), flags);
                    return false;
                }
                if ((flags & 0x40) != 0 && n1.getTypeAnnotation() != n2.getTypeAnnotation()) {
                    DeepEqual.explain(config, "attributes have different type annotations", flags);
                    return false;
                }
                boolean ar = (flags & 0x20) == 0 ? DeepEqual.deepEquals(n1.getTypedValue(), n2.getTypedValue(), collator, config, 0) : collator.comparesEqual(new StringValue(n1.getStringValueCS()), new StringValue(n2.getStringValueCS()));
                if (!ar) {
                    DeepEqual.explain(config, "attribute values differ", flags);
                }
                return ar;
            }
            case 7: 
            case 13: {
                if (n1.getFingerprint() != n2.getFingerprint()) {
                    DeepEqual.explain(config, String.valueOf(Type.displayTypeName(n1)) + " names differ", flags);
                    return false;
                }
            }
            case 3: 
            case 8: {
                boolean vr = collator.comparesEqual((AtomicValue)n1.atomize(), (AtomicValue)n2.atomize());
                if (!vr) {
                    AtomicValue av1 = (AtomicValue)n1.atomize();
                    AtomicValue av2 = (AtomicValue)n2.atomize();
                    DeepEqual.explain(config, String.valueOf(Type.displayTypeName(n1)) + " values differ (\"" + Navigator.getPath(n1) + ", " + Navigator.getPath(n2) + ": " + StringValue.diagnosticDisplay(av1.getStringValue()) + "\", \"" + StringValue.diagnosticDisplay(av2.getStringValue()) + "\")", flags);
                }
                return vr;
            }
        }
        throw new IllegalArgumentException("Unknown node type");
    }

    private static boolean isIgnorable(NodeInfo node, int flags) {
        int kind = node.getNodeKind();
        if (kind == 8) {
            return (flags & 4) == 0;
        }
        if (kind == 7) {
            return (flags & 8) == 0;
        }
        if (kind == 3) {
            return (flags & 0x10) != 0 && Whitespace.isWhite(node.getStringValueCS());
        }
        return false;
    }

    private static void explain(Configuration config, String message, int flags) {
        try {
            if ((flags & 0x80) != 0) {
                config.getErrorListener().warning(new XPathException("deep-equal(): " + message));
            }
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    private static SequenceIterator mergeAdjacentTextNodes(SequenceIterator in) throws XPathException {
        Item next;
        Configuration config = null;
        ArrayList<Item> items = new ArrayList<Item>(20);
        boolean prevIsText = false;
        FastStringBuffer textBuffer = new FastStringBuffer(64);
        while ((next = in.next()) != null) {
            if (next instanceof NodeInfo && ((NodeInfo)next).getNodeKind() == 3) {
                textBuffer.append(next.getStringValueCS());
                prevIsText = true;
                config = ((NodeInfo)next).getConfiguration();
                continue;
            }
            if (prevIsText) {
                Orphan textNode = new Orphan(config);
                textNode.setNodeKind((short)3);
                textNode.setStringValue(textBuffer.toString());
                items.add(textNode);
                textBuffer.setLength(0);
            }
            prevIsText = false;
            items.add(next);
        }
        if (prevIsText) {
            Orphan textNode = new Orphan(config);
            textNode.setNodeKind((short)3);
            textNode.setStringValue(textBuffer.toString());
            items.add(textNode);
        }
        SequenceExtent extent = new SequenceExtent(items);
        return extent.iterate();
    }
}

