/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.functions;

import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.functions.SystemFunction;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.DateTimeValue;

public class CurrentDateTime
extends SystemFunction {
    @Override
    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 1024;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        DateTimeValue dt = DateTimeValue.getCurrentDateTime(context);
        TypeHierarchy th = context.getConfiguration().getTypeHierarchy();
        int targetType = this.getItemType(th).getPrimitiveType();
        switch (targetType) {
            case 519: {
                return dt;
            }
            case 521: {
                return dt.convert(BuiltInAtomicType.DATE, true, context).asAtomic();
            }
            case 520: {
                return dt.convert(BuiltInAtomicType.TIME, true, context).asAtomic();
            }
            case 518: 
            case 634: {
                return dt.getComponent(7);
            }
        }
        throw new IllegalArgumentException("Wrong target type for current date/time");
    }
}

