/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.functions;

import net2.sf.saxon.event.SequenceReceiver;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.functions.SystemFunction;
import net2.sf.saxon.om.FastStringBuffer;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.SequenceType;
import net2.sf.saxon.value.StringValue;

public class Concat
extends SystemFunction {
    @Override
    protected SequenceType getRequiredType(int arg) {
        return this.getDetails().argumentTypes[0];
    }

    @Override
    public CharSequence evaluateAsString(XPathContext c) throws XPathException {
        return this.evaluateItem(c).getStringValueCS();
    }

    @Override
    public Item evaluateItem(XPathContext c) throws XPathException {
        int numArgs = this.argument.length;
        FastStringBuffer sb = new FastStringBuffer(64);
        int i = 0;
        while (i < numArgs) {
            AtomicValue val = (AtomicValue)this.argument[i].evaluateItem(c);
            if (val != null) {
                sb.append(val.getStringValueCS());
            }
            ++i;
        }
        return StringValue.makeStringValue(sb.condense());
    }

    @Override
    public void process(XPathContext context) throws XPathException {
        SequenceReceiver out = context.getReceiver();
        int numArgs = this.argument.length;
        out.append(StringValue.EMPTY_STRING, 0, 0);
        boolean empty = true;
        int i = 0;
        while (i < numArgs) {
            AtomicValue val = (AtomicValue)this.argument[i].evaluateItem(context);
            if (val != null) {
                out.characters(val.getStringValueCS(), 0, 0);
                empty = false;
            }
            ++i;
        }
        if (!empty) {
            out.append(StringValue.EMPTY_STRING, 0, 0);
        }
    }
}

