/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.functions;

import net2.sf.saxon.Configuration;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionTool;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.FunctionCall;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.expr.Negatable;
import net2.sf.saxon.expr.Optimizer;
import net2.sf.saxon.expr.TypeChecker;
import net2.sf.saxon.expr.ValueComparison;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.functions.SystemFunction;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.pattern.NodeTest;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.BooleanValue;

public class BooleanFn
extends SystemFunction
implements Negatable {
    public static final int BOOLEAN = 0;
    public static final int NOT = 1;
    public static final int TRUE = 2;
    public static final int FALSE = 3;

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        switch (this.operation) {
            case 0: 
            case 1: {
                return super.simplify(visitor);
            }
            case 2: {
                return Literal.makeLiteral(BooleanValue.TRUE);
            }
            case 3: {
                return Literal.makeLiteral(BooleanValue.FALSE);
            }
        }
        throw new UnsupportedOperationException("Unknown boolean operation");
    }

    @Override
    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        super.checkArguments(visitor);
        if (this.operation == 0 || this.operation == 1) {
            XPathException err = TypeChecker.ebvError(this.argument[0], visitor.getConfiguration().getTypeHierarchy());
            if (err != null) {
                err.setLocator(this);
                throw err;
            }
            Optimizer opt = visitor.getConfiguration().getOptimizer();
            this.argument[0] = ExpressionTool.unsortedIfHomogeneous(opt, this.argument[0]);
        }
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Expression e = super.optimize(visitor, contextItemType);
        if (e == this) {
            if (this.operation == 0) {
                Expression ebv = BooleanFn.rewriteEffectiveBooleanValue(this.argument[0], visitor, contextItemType);
                return ebv == null ? this : ebv.optimize(visitor, contextItemType);
            }
            if (this.operation == 1) {
                Expression ebv = BooleanFn.rewriteEffectiveBooleanValue(this.argument[0], visitor, contextItemType);
                if (ebv != null) {
                    this.argument[0] = ebv;
                }
                if (this.argument[0] instanceof Negatable && ((Negatable)((Object)this.argument[0])).isNegatable(visitor)) {
                    return ((Negatable)((Object)this.argument[0])).negate().optimize(visitor, contextItemType);
                }
                return this;
            }
        }
        return e;
    }

    @Override
    public boolean isNegatable(ExpressionVisitor visitor) {
        return true;
    }

    @Override
    public Expression negate() {
        switch (this.operation) {
            case 0: {
                return SystemFunction.makeSystemFunction("not", this.getArguments());
            }
            case 1: {
                return SystemFunction.makeSystemFunction("boolean", this.getArguments());
            }
            case 2: {
                return new Literal(BooleanValue.FALSE);
            }
            case 3: {
                return new Literal(BooleanValue.TRUE);
            }
        }
        throw new AssertionError((Object)"Unknown operation");
    }

    public static Expression rewriteEffectiveBooleanValue(Expression exp, ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        Configuration config = visitor.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        exp = ExpressionTool.unsortedIfHomogeneous(config.getOptimizer(), exp);
        if (exp instanceof ValueComparison) {
            ValueComparison vc = (ValueComparison)exp;
            if (vc.getResultWhenEmpty() == null) {
                vc.setResultWhenEmpty(BooleanValue.FALSE);
            }
            return exp;
        }
        if (exp instanceof BooleanFn && ((BooleanFn)exp).operation == 0) {
            return ((BooleanFn)exp).getArguments()[0];
        }
        if (th.isSubType(exp.getItemType(th), BuiltInAtomicType.BOOLEAN) && exp.getCardinality() == 16384) {
            return exp;
        }
        if (exp.getItemType(th) instanceof NodeTest) {
            FunctionCall exists = SystemFunction.makeSystemFunction("exists", new Expression[]{exp});
            exists.setLocationId(exp.getLocationId());
            return exists.optimize(visitor, contextItemType);
        }
        return null;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext c) throws XPathException {
        try {
            switch (this.operation) {
                case 0: {
                    return this.argument[0].effectiveBooleanValue(c);
                }
                case 1: {
                    return !this.argument[0].effectiveBooleanValue(c);
                }
                case 2: {
                    return true;
                }
                case 3: {
                    return false;
                }
            }
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            e.maybeSetContext(c);
            throw e;
        }
        throw new UnsupportedOperationException("Unknown boolean operation");
    }
}

