/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.functions;

import javax.xml.transform.SourceLocator;
import net2.sf.saxon.expr.ArithmeticExpression;
import net2.sf.saxon.expr.Atomizer;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionTool;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.LastPositionFinder;
import net2.sf.saxon.expr.Optimizer;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.functions.SystemFunction;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.BuiltInAtomicType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.Type;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.AtomicValue;
import net2.sf.saxon.value.Cardinality;
import net2.sf.saxon.value.DoubleValue;
import net2.sf.saxon.value.DurationValue;
import net2.sf.saxon.value.Int64Value;
import net2.sf.saxon.value.NumericValue;
import net2.sf.saxon.value.UntypedAtomicValue;

public class Aggregate
extends SystemFunction {
    public static final int SUM = 0;
    public static final int AVG = 1;
    public static final int COUNT = 4;

    @Override
    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        super.checkArguments(visitor);
        Optimizer opt = visitor.getConfiguration().getOptimizer();
        this.argument[0] = ExpressionTool.unsorted(opt, this.argument[0], true);
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        switch (this.operation) {
            case 4: {
                return super.getItemType(th);
            }
            case 0: {
                ItemType base = Atomizer.getAtomizedItemType(this.argument[0], false, th);
                if (base.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                    base = BuiltInAtomicType.DOUBLE;
                }
                if (Cardinality.allowsZero(this.argument[0].getCardinality())) {
                    if (this.argument.length == 1) {
                        return Type.getCommonSuperType(base, BuiltInAtomicType.INTEGER, th);
                    }
                    return Type.getCommonSuperType(base, this.argument[1].getItemType(th), th);
                }
                return base;
            }
            case 1: {
                ItemType base = Atomizer.getAtomizedItemType(this.argument[0], false, th);
                if (base.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                    return BuiltInAtomicType.DOUBLE;
                }
                if (base.getPrimitiveType() == 532) {
                    return BuiltInAtomicType.DECIMAL;
                }
                return base;
            }
        }
        throw new AssertionError((Object)"Unknown aggregate operation");
    }

    @Override
    public int computeCardinality() {
        if (this.operation == 1 && !Cardinality.allowsZero(this.argument[0].getCardinality())) {
            return 16384;
        }
        return super.computeCardinality();
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        switch (this.operation) {
            case 4: {
                SequenceIterator iter = this.argument[0].iterate(context);
                return new Int64Value(Aggregate.count(iter));
            }
            case 0: {
                AtomicValue sum = Aggregate.total(this.argument[0].iterate(context), context, this);
                if (sum != null) {
                    return sum;
                }
                if (this.argument.length == 2) {
                    return this.argument[1].evaluateItem(context);
                }
                return Int64Value.ZERO;
            }
            case 1: {
                return Aggregate.average(this.argument[0].iterate(context), context, this);
            }
        }
        throw new UnsupportedOperationException("Unknown aggregate function");
    }

    public static AtomicValue total(SequenceIterator iter, XPathContext context, SourceLocator location) throws XPathException {
        AtomicValue sum = (AtomicValue)iter.next();
        if (sum == null) {
            return null;
        }
        if (sum instanceof UntypedAtomicValue) {
            try {
                sum = sum.convert(BuiltInAtomicType.DOUBLE, true, context).asAtomic();
            }
            catch (XPathException e) {
                e.maybeSetLocation(location);
                throw e;
            }
        }
        if (sum instanceof NumericValue) {
            AtomicValue next;
            do {
                if ((next = (AtomicValue)iter.next()) == null) {
                    return sum;
                }
                if (next instanceof UntypedAtomicValue) {
                    next = next.convert(BuiltInAtomicType.DOUBLE, true, context).asAtomic();
                    continue;
                }
                if (next instanceof NumericValue) continue;
                XPathException err = new XPathException("Input to sum() contains a mix of numeric and non-numeric values");
                err.setXPathContext(context);
                err.setErrorCode("FORG0006");
                err.setLocator(location);
                throw err;
            } while (!(sum = ArithmeticExpression.compute(sum, 0, next, context)).isNaN() || !(sum instanceof DoubleValue));
            return sum;
        }
        if (sum instanceof DurationValue) {
            while (true) {
                AtomicValue next;
                if ((next = (AtomicValue)iter.next()) == null) {
                    return sum;
                }
                if (!(next instanceof DurationValue)) {
                    XPathException err = new XPathException("Input to sum() contains a mix of duration and non-duration values");
                    err.setXPathContext(context);
                    err.setErrorCode("FORG0006");
                    err.setLocator(location);
                    throw err;
                }
                sum = ((DurationValue)sum).add((DurationValue)next);
            }
        }
        XPathException err = new XPathException("Input to sum() contains a value that is neither numeric, nor a duration");
        err.setXPathContext(context);
        err.setErrorCode("FORG0006");
        err.setLocator(location);
        throw err;
    }

    public static AtomicValue average(SequenceIterator iter, XPathContext context, SourceLocator location) throws XPathException {
        int count = 0;
        AtomicValue item = (AtomicValue)iter.next();
        if (item == null) {
            return null;
        }
        ++count;
        if (item instanceof UntypedAtomicValue) {
            try {
                item = item.convert(BuiltInAtomicType.DOUBLE, true, context).asAtomic();
            }
            catch (XPathException e) {
                e.maybeSetLocation(location);
                throw e;
            }
        }
        if (item instanceof NumericValue) {
            AtomicValue next;
            do {
                if ((next = (AtomicValue)iter.next()) == null) {
                    return ArithmeticExpression.compute(item, 3, new Int64Value(count), context);
                }
                ++count;
                if (next instanceof UntypedAtomicValue) {
                    try {
                        next = next.convert(BuiltInAtomicType.DOUBLE, true, context).asAtomic();
                    }
                    catch (XPathException e) {
                        e.maybeSetLocation(location);
                        throw e;
                    }
                } else {
                    if (next instanceof NumericValue) continue;
                    XPathException err = new XPathException("Input to avg() contains a mix of numeric and non-numeric values");
                    err.setXPathContext(context);
                    err.setErrorCode("FORG0006");
                    err.setLocator(location);
                    throw err;
                }
            } while (!(item = ArithmeticExpression.compute(item, 0, next, context)).isNaN() || !(item instanceof DoubleValue));
            return item;
        }
        if (item instanceof DurationValue) {
            while (true) {
                AtomicValue next;
                if ((next = (AtomicValue)iter.next()) == null) {
                    return ((DurationValue)item).multiply(1.0 / (double)count);
                }
                ++count;
                if (!(next instanceof DurationValue)) {
                    XPathException err = new XPathException("Input to avg() contains a mix of duration and non-duration values");
                    err.setXPathContext(context);
                    err.setErrorCode("FORG0006");
                    err.setLocator(location);
                    throw err;
                }
                item = ((DurationValue)item).add((DurationValue)next);
            }
        }
        XPathException err = new XPathException("Input to avg() contains a value that is neither numeric, nor a duration");
        err.setXPathContext(context);
        err.setErrorCode("FORG0006");
        err.setLocator(location);
        throw err;
    }

    public static int count(SequenceIterator iter) throws XPathException {
        if ((iter.getProperties() & 2) != 0) {
            return ((LastPositionFinder)iter).getLastPosition();
        }
        int n = 0;
        while (iter.next() != null) {
            ++n;
        }
        return n;
    }

    public static boolean isCountFunction(Expression exp) {
        if (!(exp instanceof Aggregate)) {
            return false;
        }
        Aggregate ag = (Aggregate)exp;
        return ag.getNumberOfArguments() == 1 && ag.operation == 4;
    }
}

