/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import java.util.Iterator;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.Controller;
import net2.sf.saxon.event.ComplexContentOutputter;
import net2.sf.saxon.event.NamespaceReducer;
import net2.sf.saxon.event.PipelineConfiguration;
import net2.sf.saxon.event.Receiver;
import net2.sf.saxon.event.SequenceReceiver;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.LastPositionFinder;
import net2.sf.saxon.expr.PathExpression;
import net2.sf.saxon.expr.StackFrame;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.expr.XPathContextMajor;
import net2.sf.saxon.instruct.LocalParam;
import net2.sf.saxon.instruct.ParameterSet;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.LookaheadIterator;
import net2.sf.saxon.om.NameChecker;
import net2.sf.saxon.om.NamePool;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.StructuredQName;
import net2.sf.saxon.om.ValueRepresentation;
import net2.sf.saxon.regex.RegexIterator;
import net2.sf.saxon.sort.CodepointCollator;
import net2.sf.saxon.sort.GroupIterator;
import net2.sf.saxon.sort.StringCollator;
import net2.sf.saxon.trace.ContextStackIterator;
import net2.sf.saxon.trace.InstructionInfo;
import net2.sf.saxon.trans.Mode;
import net2.sf.saxon.trans.Rule;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.SchemaType;
import net2.sf.saxon.value.DateTimeValue;

public class XPathContextMinor
implements XPathContext {
    Controller controller;
    SequenceIterator currentIterator;
    LastValue last = null;
    SequenceReceiver currentReceiver;
    boolean isTemporaryDestination = false;
    XPathContext caller = null;
    protected StackFrame stackFrame;
    Object origin = null;
    XPathException currentException;

    protected XPathContextMinor() {
    }

    @Override
    public XPathContextMajor newContext() {
        return XPathContextMajor.newContext(this);
    }

    @Override
    public XPathContextMinor newMinorContext() {
        XPathContextMinor c = new XPathContextMinor();
        c.controller = this.controller;
        c.caller = this;
        c.currentIterator = this.currentIterator;
        c.currentReceiver = this.currentReceiver;
        c.last = this.last;
        c.isTemporaryDestination = this.isTemporaryDestination;
        c.stackFrame = this.stackFrame;
        c.currentException = this.currentException;
        return c;
    }

    @Override
    public void setCaller(XPathContext caller) {
        this.caller = caller;
    }

    @Override
    public XPathContextMajor newCleanContext() {
        XPathContextMajor c = new XPathContextMajor(this.getController());
        c.setCaller(this);
        return c;
    }

    @Override
    public ParameterSet getLocalParameters() {
        return this.getCaller().getLocalParameters();
    }

    @Override
    public ParameterSet getTunnelParameters() {
        return this.getCaller().getTunnelParameters();
    }

    @Override
    public void setOrigin(InstructionInfo expr) {
        this.origin = expr;
    }

    @Override
    public void setOriginatingConstructType(int loc) {
        this.origin = new Integer(loc);
    }

    @Override
    public int getOriginatingConstructType() {
        if (this.origin == null) {
            return -1;
        }
        if (this.origin instanceof Expression) {
            if (this.origin instanceof PathExpression) {
                return 2025;
            }
            return ((Expression)this.origin).getConstructType();
        }
        if (this.origin instanceof Integer) {
            return (Integer)this.origin;
        }
        if (this.origin instanceof InstructionInfo) {
            return ((InstructionInfo)this.origin).getConstructType();
        }
        return -1;
    }

    @Override
    public InstructionInfo getOrigin() {
        if (this.origin instanceof InstructionInfo) {
            return (InstructionInfo)this.origin;
        }
        return null;
    }

    @Override
    public final Controller getController() {
        return this.controller;
    }

    @Override
    public final Configuration getConfiguration() {
        return this.controller.getConfiguration();
    }

    @Override
    public final NamePool getNamePool() {
        return this.controller.getNamePool();
    }

    public final NameChecker getNameChecker() {
        return this.controller.getConfiguration().getNameChecker();
    }

    @Override
    public final XPathContext getCaller() {
        return this.caller;
    }

    @Override
    public void setCurrentIterator(SequenceIterator iter) {
        this.currentIterator = iter;
        this.last = new LastValue(-1);
    }

    @Override
    public final SequenceIterator getCurrentIterator() {
        return this.currentIterator;
    }

    @Override
    public final int getContextPosition() throws XPathException {
        if (this.currentIterator == null) {
            XPathException e = new XPathException("The context position is currently undefined");
            e.setXPathContext(this);
            e.setErrorCode("FONC0001");
            throw e;
        }
        return this.currentIterator.position();
    }

    @Override
    public final Item getContextItem() {
        if (this.currentIterator == null) {
            return null;
        }
        return this.currentIterator.current();
    }

    @Override
    public final int getLast() throws XPathException {
        if (this.currentIterator == null) {
            XPathException e = new XPathException("The context size is currently undefined");
            e.setXPathContext(this);
            e.setErrorCode("FONC0001");
            throw e;
        }
        if (this.last.value >= 0) {
            return this.last.value;
        }
        if ((this.currentIterator.getProperties() & 2) == 0) {
            SequenceIterator another = this.currentIterator.getAnother();
            int count = 0;
            while (another.next() != null) {
                ++count;
            }
            this.last.value = count;
            return this.last.value;
        }
        this.last.value = ((LastPositionFinder)this.currentIterator).getLastPosition();
        return this.last.value;
    }

    @Override
    public final boolean isAtLast() throws XPathException {
        if ((this.currentIterator.getProperties() & 4) != 0) {
            return !((LookaheadIterator)this.currentIterator).hasNext();
        }
        return this.getContextPosition() == this.getLast();
    }

    @Override
    public final StringCollator getCollation(String name) throws XPathException {
        if (name.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            return CodepointCollator.getInstance();
        }
        StringCollator collation = null;
        if (this.controller != null && (collation = this.controller.getExecutable().getNamedCollation(name)) == null) {
            Configuration config = this.controller.getConfiguration();
            collation = config.getCollationURIResolver().resolve(name, null, config);
        }
        if (collation == null) {
            XPathException e = new XPathException("Unknown collation " + name);
            e.setErrorCode("FOCH0002");
            e.setXPathContext(this);
            throw e;
        }
        return collation;
    }

    @Override
    public StackFrame getStackFrame() {
        return this.stackFrame;
    }

    @Override
    public ValueRepresentation evaluateLocalVariable(int slotnumber) {
        return this.stackFrame.slots[slotnumber];
    }

    @Override
    public void setLocalVariable(int slotnumber, ValueRepresentation value) {
        try {
            this.stackFrame.slots[slotnumber] = value;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new AssertionError((Object)("Internal error: invalid slot number for local variable " + (slotnumber == -999 ? "(No slot allocated)" : "(" + slotnumber + ")")));
        }
    }

    @Override
    public void changeOutputDestination(Receiver receiver, boolean isFinal, int validation, SchemaType schemaType) throws XPathException {
        if (isFinal && this.isTemporaryDestination) {
            XPathException err = new XPathException("Cannot switch to a final result destination while writing a temporary tree");
            err.setErrorCode("XTDE1480");
            throw err;
        }
        if (isFinal) {
            validation |= 0x10000;
        } else {
            this.isTemporaryDestination = true;
        }
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        ComplexContentOutputter out = new ComplexContentOutputter();
        out.setHostLanguage(pipe.getHostLanguage());
        out.setPipelineConfiguration(pipe);
        NamespaceReducer ne = new NamespaceReducer();
        ne.setUnderlyingReceiver(receiver);
        ne.setPipelineConfiguration(pipe);
        receiver = this.controller.getConfiguration().getDocumentValidator(ne, receiver.getSystemId(), validation, 0, schemaType, -1);
        out.setReceiver(receiver);
        this.currentReceiver = out;
    }

    @Override
    public void setTemporaryReceiver(SequenceReceiver out) {
        this.isTemporaryDestination = true;
        this.currentReceiver = out;
    }

    @Override
    public void setReceiver(SequenceReceiver receiver) {
        this.currentReceiver = receiver;
    }

    @Override
    public final SequenceReceiver getReceiver() {
        return this.currentReceiver;
    }

    @Override
    public int useLocalParameter(StructuredQName qName, LocalParam binding, boolean isTunnel) throws XPathException {
        return this.getCaller().useLocalParameter(qName, binding, isTunnel);
    }

    @Override
    public Mode getCurrentMode() {
        return this.getCaller().getCurrentMode();
    }

    @Override
    public Rule getCurrentTemplateRule() {
        return this.getCaller().getCurrentTemplateRule();
    }

    @Override
    public GroupIterator getCurrentGroupIterator() {
        return this.getCaller().getCurrentGroupIterator();
    }

    @Override
    public RegexIterator getCurrentRegexIterator() {
        return this.getCaller().getCurrentRegexIterator();
    }

    @Override
    public DateTimeValue getCurrentDateTime() {
        return this.controller.getCurrentDateTime();
    }

    @Override
    public final int getImplicitTimezone() {
        return this.controller.getImplicitTimezone();
    }

    public void setTemporaryOutputState(boolean temp) {
        this.isTemporaryDestination = temp;
    }

    @Override
    public Iterator iterateStackFrames() {
        return new ContextStackIterator(this);
    }

    public void setCurrentException(XPathException exception) {
        this.currentException = exception;
    }

    @Override
    public XPathException getCurrentException() {
        return this.currentException;
    }

    private static class LastValue {
        public int value = 0;

        public LastValue(int count) {
            this.value = count;
        }
    }
}

