/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import java.util.Iterator;
import net2.sf.saxon.Configuration;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.expr.MonoIterator;
import net2.sf.saxon.expr.PromotionOffer;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.SequenceExtent;
import net2.sf.saxon.value.Value;

public abstract class UnaryExpression
extends Expression {
    protected Expression operand;

    public UnaryExpression(Expression p0) {
        this.operand = p0;
        this.adoptChildExpression(p0);
    }

    public Expression getBaseExpression() {
        return this.operand;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.operand = visitor.simplify(this.operand);
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        try {
            if (this.operand instanceof Literal) {
                return Literal.makeLiteral(Value.asValue(SequenceExtent.makeSequenceExtent(this.iterate(visitor.getStaticContext().makeEarlyEvaluationContext()))));
            }
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand = visitor.optimize(this.operand, contextItemType);
        try {
            if (this.operand instanceof Literal) {
                return Literal.makeLiteral(Value.asValue(SequenceExtent.makeSequenceExtent(this.iterate(visitor.getStaticContext().makeEarlyEvaluationContext()))));
            }
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
        return this;
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        this.operand = this.doPromotion(this, this.operand, offer);
        return this;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new MonoIterator(this.operand);
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.operand == original) {
            this.operand = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public int computeSpecialProperties() {
        return this.operand.getSpecialProperties();
    }

    @Override
    public int computeCardinality() {
        return this.operand.getCardinality();
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return this.operand.getItemType(th);
    }

    public boolean equals(Object other) {
        return this.getClass().equals(other.getClass()) && this.operand.equals(((UnaryExpression)other).operand);
    }

    public int hashCode() {
        return ("UnaryExpression " + this.getClass()).hashCode() ^ this.operand.hashCode();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + this.operand.toString() + ")";
    }

    @Override
    public void explain(ExpressionPresenter out) {
        String name = this.displayExpressionName();
        if (name == null) {
            out.startElement("unaryOperator");
            String op = this.displayOperator(out.getConfiguration());
            if (op != null) {
                out.emitAttribute("op", op);
            }
        } else {
            out.startElement(name);
        }
        this.operand.explain(out);
        out.endElement();
    }

    protected String displayOperator(Configuration config) {
        return null;
    }

    protected String displayExpressionName() {
        return null;
    }
}

