/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import net2.sf.saxon.expr.LastPositionFinder;
import net2.sf.saxon.expr.ValueTailIterator;
import net2.sf.saxon.om.ArrayIterator;
import net2.sf.saxon.om.EmptyIterator;
import net2.sf.saxon.om.GroundedIterator;
import net2.sf.saxon.om.GroundedValue;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.LookaheadIterator;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.value.EmptySequence;

public class TailIterator
implements SequenceIterator,
LastPositionFinder,
LookaheadIterator {
    private SequenceIterator base;
    private int start;

    private TailIterator(SequenceIterator base, int start) throws XPathException {
        this.base = base;
        this.start = start;
    }

    public static SequenceIterator make(SequenceIterator base, int start) throws XPathException {
        if (start <= 1) {
            return base;
        }
        if (base instanceof ArrayIterator) {
            return ((ArrayIterator)base).makeSliceIterator(start, Integer.MAX_VALUE);
        }
        if (base instanceof GroundedIterator) {
            GroundedValue value = ((GroundedIterator)base).materialize();
            if (value == EmptySequence.getInstance()) {
                return EmptyIterator.getInstance();
            }
            return new ValueTailIterator(value, start - 1);
        }
        int i = 0;
        while (i < start - 1) {
            Item b = base.next();
            if (b == null) {
                return EmptyIterator.getInstance();
            }
            ++i;
        }
        return new TailIterator(base, start);
    }

    @Override
    public Item next() throws XPathException {
        return this.base.next();
    }

    @Override
    public Item current() {
        return this.base.current();
    }

    @Override
    public int position() {
        int bp = this.base.position();
        return bp > 0 ? this.base.position() - this.start + 1 : bp;
    }

    @Override
    public boolean hasNext() {
        return ((LookaheadIterator)this.base).hasNext();
    }

    @Override
    public int getLastPosition() throws XPathException {
        int bl = ((LastPositionFinder)this.base).getLastPosition() - this.start + 1;
        return bl > 0 ? bl : 0;
    }

    @Override
    public void close() {
        this.base.close();
    }

    @Override
    public SequenceIterator getAnother() throws XPathException {
        return TailIterator.make(this.base.getAnother(), this.start);
    }

    @Override
    public int getProperties() {
        return this.base.getProperties() & 6;
    }
}

