/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import java.util.Iterator;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.Literal;
import net2.sf.saxon.expr.MonoIterator;
import net2.sf.saxon.expr.PromotionOffer;
import net2.sf.saxon.expr.TailIterator;
import net2.sf.saxon.expr.ValueTailIterator;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.GroundedIterator;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.ValueRepresentation;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.SequenceExtent;
import net2.sf.saxon.value.Value;

public class TailExpression
extends Expression {
    Expression base;
    int start;

    public TailExpression(Expression base, int start) {
        this.base = base;
        this.start = start;
        this.adoptChildExpression(base);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.base = visitor.typeCheck(this.base, contextItemType);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.base = visitor.optimize(this.base, contextItemType);
        if (this.base instanceof Literal) {
            ValueRepresentation value = SequenceExtent.makeSequenceExtent(this.iterate(visitor.getStaticContext().makeEarlyEvaluationContext()));
            return Literal.makeLiteral(Value.asValue(value));
        }
        return this;
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        if (offer.action != 13) {
            this.base = this.doPromotion(this, this.base, offer);
        }
        return this;
    }

    @Override
    public int computeSpecialProperties() {
        return this.base.getSpecialProperties();
    }

    @Override
    public Expression copy() {
        return new TailExpression(this.base.copy(), this.start);
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return this.base.getItemType(th);
    }

    @Override
    public int computeCardinality() {
        return this.base.getCardinality() | 0x2000;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new MonoIterator(this.base);
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.base == original) {
            this.base = replacement;
            found = true;
        }
        return found;
    }

    public Expression getBaseExpression() {
        return this.base;
    }

    public int getStart() {
        return this.start;
    }

    public boolean equals(Object other) {
        return other instanceof TailExpression && this.base.equals(((TailExpression)other).base) && this.start == ((TailExpression)other).start;
    }

    public int hashCode() {
        return this.base.hashCode();
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator baseIter = this.base.iterate(context);
        if ((baseIter.getProperties() & 1) != 0) {
            return new ValueTailIterator(((GroundedIterator)baseIter).materialize(), this.start - 1);
        }
        return TailIterator.make(baseIter, this.start);
    }

    @Override
    public void explain(ExpressionPresenter destination) {
        destination.startElement("tail");
        destination.emitAttribute("start", String.valueOf(this.start));
        this.base.explain(destination);
        destination.endElement();
    }
}

