/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionTool;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.UnaryExpression;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.expr.XPathContextMajor;
import net2.sf.saxon.instruct.UserFunction;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.ValueRepresentation;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.SequenceExtent;
import net2.sf.saxon.value.Value;

public final class TailCallLoop
extends UnaryExpression {
    UserFunction containingFunction;

    public TailCallLoop(UserFunction function) {
        super(function.getBody());
        this.containingFunction = function;
    }

    public UserFunction getContainingFunction() {
        return this.containingFunction;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        return this;
    }

    @Override
    public int getImplementationMethod() {
        return this.operand.getImplementationMethod();
    }

    @Override
    public Expression copy() {
        throw new UnsupportedOperationException("copy");
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        UserFunction fn;
        XPathContextMajor cm = (XPathContextMajor)context;
        do {
            SequenceIterator iter = this.operand.iterate(cm);
            ValueRepresentation extent = SequenceExtent.makeSequenceExtent(iter);
            fn = cm.getTailCallFunction();
            if (fn != null) continue;
            return Value.asIterator(extent);
        } while (fn == this.containingFunction);
        return Value.asIterator(this.tailCallDifferentFunction(fn, cm));
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        UserFunction fn;
        XPathContextMajor cm = (XPathContextMajor)context;
        do {
            Item item = this.operand.evaluateItem(context);
            fn = cm.getTailCallFunction();
            if (fn != null) continue;
            return item;
        } while (fn == this.containingFunction);
        return Value.asItem(this.tailCallDifferentFunction(fn, cm));
    }

    @Override
    public void process(XPathContext context) throws XPathException {
        UserFunction fn;
        XPathContextMajor cm = (XPathContextMajor)context;
        do {
            this.operand.process(context);
            fn = cm.getTailCallFunction();
            if (fn != null) continue;
            return;
        } while (fn == this.containingFunction);
        Value.asValue(this.tailCallDifferentFunction(fn, cm)).process(cm);
    }

    private ValueRepresentation tailCallDifferentFunction(UserFunction fn, XPathContextMajor cm) throws XPathException {
        cm.resetStackFrameMap(fn.getStackFrameMap(), fn.getNumberOfArguments());
        try {
            return ExpressionTool.evaluate(fn.getBody(), fn.getEvaluationMode(), cm, 1);
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            err.maybeSetContext(cm);
            throw err;
        }
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return this.operand.getItemType(th);
    }

    @Override
    protected String displayExpressionName() {
        return "tailCallLoop";
    }
}

