/*
 * Decompiled with CFR 0.152.
 */
package net2.sf.saxon.expr;

import net2.sf.saxon.StandardErrorListener;
import net2.sf.saxon.expr.Expression;
import net2.sf.saxon.expr.ExpressionVisitor;
import net2.sf.saxon.expr.XPathContext;
import net2.sf.saxon.om.Item;
import net2.sf.saxon.om.SequenceIterator;
import net2.sf.saxon.om.ValueRepresentation;
import net2.sf.saxon.trace.ExpressionPresenter;
import net2.sf.saxon.trans.XPathException;
import net2.sf.saxon.type.AnyItemType;
import net2.sf.saxon.type.ItemType;
import net2.sf.saxon.type.TypeHierarchy;
import net2.sf.saxon.value.SequenceType;
import net2.sf.saxon.value.Value;

public class SuppliedParameterReference
extends Expression {
    int slotNumber;
    SequenceType type;

    public SuppliedParameterReference(int slot) {
        this.slotNumber = slot;
    }

    public void setSuppliedType(SequenceType type) {
        this.type = type;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        return this;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        if (this.type != null) {
            return this.type.getPrimaryType();
        }
        return AnyItemType.getInstance();
    }

    @Override
    public int getIntrinsicDependencies() {
        return 128;
    }

    @Override
    public int computeCardinality() {
        if (this.type != null) {
            return this.type.getCardinality();
        }
        return 57344;
    }

    @Override
    public Expression copy() {
        return new SuppliedParameterReference(this.slotNumber);
    }

    public ValueRepresentation evaluateVariable(XPathContext c) throws XPathException {
        try {
            return c.evaluateLocalVariable(this.slotNumber);
        }
        catch (AssertionError e) {
            StandardErrorListener.printStackTrace(System.err, c);
            throw new AssertionError((Object)(String.valueOf(((Throwable)((Object)e)).getMessage()) + ". No value has been set for parameter " + this.slotNumber));
        }
    }

    @Override
    public SequenceIterator iterate(XPathContext c) throws XPathException {
        try {
            return Value.getIterator(c.evaluateLocalVariable(this.slotNumber));
        }
        catch (AssertionError e) {
            StandardErrorListener.printStackTrace(System.err, c);
            throw new AssertionError((Object)(String.valueOf(((Throwable)((Object)e)).getMessage()) + ". No value has been set for parameter " + this.slotNumber));
        }
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        ValueRepresentation actual = context.evaluateLocalVariable(this.slotNumber);
        return Value.asItem(actual);
    }

    @Override
    public void explain(ExpressionPresenter destination) {
        destination.startElement("suppliedParam");
        destination.emitAttribute("slot", String.valueOf(this.slotNumber));
        destination.endElement();
    }

    @Override
    public String toString() {
        return "suppliedParam(" + this.slotNumber + ")";
    }
}

